package com.liquidnet.service.consumer.service.processor;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.consumer.service.IBaseDao;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;
import org.springframework.amqp.core.Message;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * ConsumerProcessor.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2021/4/29
 */
@Slf4j
@Component
public class ConsumerProcessor {
    @Resource
    IBaseDao baseDao;

//    @RabbitListener(bindings = @QueueBinding(
//            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL), key = MQConst.ROUTING_KEY_SQL,
//            value = @Queue(MQConst.QUEUES_SQL_MAIN)
//    ))
////    @RabbitListener(queues = MQConst.QUEUES_SQL_MAIN)
//    public void consumerSql(Message msg, Channel channel) {
//        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
//        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
//        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));
//
//        try {
//            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
//            log.debug("consumer sql result of execution:{}", rstBatchSqls);
//            if (rstBatchSqls) {
//                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
//            } else {
//                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
//            }
//        } catch (Exception e) {
//            log.error("error:consumer sql:{}", JsonUtils.toJson(sqlMessage), e);
//            try {
//                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
//            } catch (IOException ioException) {
//                log.error("error:consumer sql:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
//            }
//        }
//    }

    private void consumerSqlDaoHandler(Message msg, Channel channel) {
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));
        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("consumer sql result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (IOException e) {
            log.error("error:consumer sql:Channel.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), e);
        }
    }

    // 用户注册
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER), key = MQConst.RK_SQL_UREGISTER,
            value = @Queue(MQConst.QUEUES_SQL_UREGISTER)
    ))
    public void consumerSqlForURegister(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 用户信息
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER), key = MQConst.RK_SQL_UCENTER,
            value = @Queue(MQConst.QUEUES_SQL_UCENTER)
    ))
    public void consumerSqlForUCenter(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 会员购买
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER), key = MQConst.RK_SQL_UMEMBER,
            value = @Queue(MQConst.QUEUES_SQL_UMEMBER)
    ))
    public void consumerSqlForUMember(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 验票更新
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_STATION), key = MQConst.RK_SQL_STATION,
            value = @Queue(MQConst.QUEUES_SQL_STATION)
    ))
    public void consumerSqlForStation(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 订单创建
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate1(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate2(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate3(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate4(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate5(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate6(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate7(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate8(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate9(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 订单再次支付
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_AGAIN), key = MQConst.ROUTING_KEY_SQL_ORDER_AGAIN,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_AGAIN)
    ))
    public void consumerOrderPayAgain(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY_AGAIN   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 订单关闭
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose1(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose2(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose3(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose4(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose5(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose6(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose7(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose8(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose9(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }


    // 订单支付
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay1(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay2(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay3(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay4(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay5(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay6(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay7(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay8(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }@RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay9(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))

    // 缺票登记
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_PERFORMANCE_LACK), key = MQConst.ROUTING_KEY_SQL_PERFORMANCE_LACK,
            value = @Queue(MQConst.QUEUES_SQL_PERFORMANCE_LACK)
    ))
    public void consumerPerformanceLack(Message msg, Channel channel) {
        log.info("===   CONSUMER_PERFORMANCE_LACK   ===");
        this.consumerSqlDaoHandler(msg, channel);
    }
}
