package com.liquidnet.service.account.wallet.service.impl;

import com.liquidnet.service.account.wallet.entity.FinUser;
import com.liquidnet.service.account.wallet.entity.FinUserExample;
import com.liquidnet.service.account.wallet.mapper.FinUserMapper;
import com.liquidnet.service.account.wallet.service.FinUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class FinUserServiceImpl implements FinUserService {
    private static final Logger log = LoggerFactory.getLogger(FinUserServiceImpl.class);
    @Autowired
    private FinUserMapper userMapper;

    @Override
    public int queryForCount(String channelId, List<String> finIds) {
        FinUserExample example = new FinUserExample();
        example.createCriteria().andChannelIdEqualTo(channelId).andFinIdIn(finIds);
        return userMapper.countByExample(example);
    }

    @Override
    public FinUser queryByUserExtId(String userExtId) {
        FinUserExample example = new FinUserExample();
        example.createCriteria().andUserExtIdEqualTo(userExtId);
        List<FinUser> list = userMapper.selectByExample(example);
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    @Override
    public int addUser(FinUser user) {
        return userMapper.insertSelective(user);
    }
}
