package com.liquidnet.service.adam.controller;


import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.AdamMemberOrderCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderResult;
import com.liquidnet.service.adam.dto.vo.AdamMemberOrderVo;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import com.liquidnet.service.adam.service.IAdamMemberOrderService;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "购买会员")
@Slf4j
@RestController
@RequestMapping("/member/order")
public class AdamMemberOrderController {

    @Autowired
    IAdamMemberOrderService adamMemberOrderService;

    @ApiOperationSupport(order = 0)
    @ApiOperation(value = "购买会员或会员码")
    @PostMapping("/buy/member")
    public ResponseDto<AdamMemberOrderResult> buyMemberOrCode(AdamMemberOrderParam param) {
        AdamMemberOrderResult adamMemberOrderResult = null;
        try {
            adamMemberOrderResult = adamMemberOrderService.buyMemberOrMemberCode(param);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
        return ResponseDto.success(adamMemberOrderResult);
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "使用兑换码")
    @PostMapping("/use/memberCode")
    public ResponseDto<AdamMemberOrder> useMemberCode(AdamMemberOrderCodeParam param) {
        try {
            boolean result = adamMemberOrderService.useMemberCode(param);
            if (!result) {
                return ResponseDto.failure("兑换失败");
            }
            return ResponseDto.success();
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "会员订单列表")
    @GetMapping("/member/order/list")
    public ResponseDto<List<AdamMemberOrderVo>> getMemberOrderList() {
        String currentUid = CurrentUtil.getCurrentUid();
        List<AdamMemberOrderVo> memberOrderList = adamMemberOrderService.getMemberOrderList(currentUid);
        return ResponseDto.success(memberOrderList);
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "会员订单详情")
    @GetMapping("/member/order/info/{orderNo}")
    public ResponseDto<AdamMemberOrderVo> getMemberOrderList(@PathVariable String orderNo) {
        String currentUid = CurrentUtil.getCurrentUid();
        AdamMemberOrderVo memberOrderInfo = adamMemberOrderService.getMemberOrderInfo(currentUid, orderNo);
        return ResponseDto.success(memberOrderInfo);
    }
}
