package com.liquidnet.service.executor.main.handler;

import com.alibaba.fastjson.JSON;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.feign.adam.task.FeignTaskAdamConversionClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class ExecutorAdamConversionHandler {

    @Autowired
    private FeignTaskAdamConversionClient feignTaskAdamConversionClient;

    @XxlJob(value = "sev-adam:conversionSendConfirmTask")
    public ReturnT<String> conversionSendConfirmTask(String param) {
        XxlJobLogger.log("start:adam.conversion.sendConfirmTask");
        ResponseDto responseDto = feignTaskAdamConversionClient.sendConfirmTask();
        XxlJobLogger.log("end:adam.conversion:[{}]", JSON.toJSONString(responseDto));
        return ReturnT.SUCCESS;
    }

}
