package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.BannersVo;
import com.liquidnet.service.kylin.service.impl.admin.KylinBannersServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 轮播图 前端接口控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-10
 */

@Api(tags = "前端-banner")
@RestController
@RequestMapping("banners")
public class KylinBannersController {

    @Autowired
    private KylinBannersServiceImpl kylinBannersServiceImpl;

    @GetMapping("")
    @ApiOperation("banner列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "position", value = "展示位置 1首页 3周边 4演出 5积分商城 6YB 8视频", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "provinceName", value = "城市名称"),
    })
    public ResponseDto<List<BannersVo>> blist(
            @RequestParam() String position,
            @RequestParam(defaultValue = "") String provinceName
    ) {
        List result = new ArrayList();
        result = kylinBannersServiceImpl.blist(position, provinceName);

        return ResponseDto.success(result);
    }

}
