package com.liquidnet.service.account.wallet.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.account.wallet.bo.FinBizTransDetailBo;
import com.liquidnet.service.account.wallet.entity.FinBizTrans;
import com.liquidnet.service.account.wallet.mapper.FinBizTransMapper;
import com.liquidnet.service.account.wallet.service.FinBizTransService;
import com.liquidnet.service.account.wallet.vo.WalletDashboardInfoVo;
import com.liquidnet.service.account.wallet.vo.WalletTransactionInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * FinBizTransServiceImpl.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
@Service
public class FinBizTransServiceImpl implements FinBizTransService {
    private static final Logger log = LoggerFactory.getLogger(FinBizTransServiceImpl.class);
    @Autowired
    private FinBizTransMapper transMapper;

    @Override
    public int add(FinBizTrans record) {
        return transMapper.insertSelective(record);
    }

    @Override
    public int update(FinBizTrans record) {
        return transMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public List<FinBizTrans> queryTransToBeCalculated(int limitSize) {
        PageHelper.startPage(1, limitSize);
        return transMapper.selectTransToBeCalculated();
    }

    @Override
    public List<WalletTransactionInfoVo> queryTransDetails(Map<String, Object> parameter) {
        List<FinBizTransDetailBo> transDetailsBoList = transMapper.selectTransDetails(parameter);
        return JsonUtils.fromJson(JsonUtils.toJson(transDetailsBoList), new TypeReference<List<WalletTransactionInfoVo>>() {
        });
    }

    @Override
    public List<WalletDashboardInfoVo> queryTransBalanceStats(Map<String, Object> parameter) {
        List<Map<String, Object>> list = transMapper.selectTransBalanceStats(parameter);
        List<WalletDashboardInfoVo> voList = JsonUtils.fromJson(JsonUtils.toJson(list), new TypeReference<List<WalletDashboardInfoVo>>() {
        });
        /*if (!CollectionUtils.isEmpty(voList)) {
            FinConstants.Dashboard.Period period = FinConstants.Dashboard.Period.byFmt(String.valueOf(parameter.get("groupingDateFormat")));
            DateTimeFormatter df = DateTimeFormatter.ofPattern(period.getFmt2(), Locale.ENGLISH);
            if (period == FinConstants.Dashboard.Period.L24H) {
                voList.forEach(r -> {
                    LocalDateTime tmpTime = LocalDateTime.parse(r.getUnitId(), df);
                    r.setUnitId(String.valueOf(tmpTime.atZone(TimeZone.getTimeZone("UTC").toZoneId()).toInstant().getEpochSecond()));
                });
            } else {
                voList.forEach(r -> {
                    LocalDate tmpTime = LocalDate.parse(r.getUnitId(), df);
                    r.setUnitId(String.valueOf(tmpTime.atStartOfDay(TimeZone.getTimeZone("UTC").toZoneId()).toInstant().getEpochSecond()));
                });
            }
        }*/
        return voList;
    }
}
