package com.liquidnet.service.merchant.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 主办表
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MerchantSponsors implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * sponsor_id
     */
    private String sponsorId;

    /**
     * 上线状态 0下线 1下线
     */
    private Integer isOnline;

    /**
     * 主办所有者账号
     */
    private String uid;

    /**
     * 名称
     */
    private String name;

    /**
     * logo图片地址
     */
    private String logo;

    /**
     * 背景图片地址
     */
    private String background;

    /**
     * 介绍
     */
    private String description;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系人身份证号码
     */
    private String contactIdentity;

    /**
     * 联系人身份证正面照
     */
    private String contactIdentityObverse;

    /**
     * 联系人身份证反面照
     */
    private String contactIdentityReverse;

    /**
     * 联系人邮箱
     */
    private String contactEmail;

    /**
     * 企业信息ID
     */
    private String companyId;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
