package com.liquidnet.service.reconciliation.util.csv.annotation;

import com.liquidnet.service.reconciliation.util.csv.base.CsvType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value = { ElementType.FIELD })
@Retention(value = RetentionPolicy.RUNTIME)
public @interface CsvIndexer {
	int index();

	CsvType type() default CsvType.STRING;
	
	boolean defaultValue() default false;//表示反射可以根据类型设置默认值，防止beancopy的时候某些字段为空类型转换失败
}
