package com.liquidnet.service.consumer.base.receiver.dragon;

import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.base.receiver.AbstractSqlRedisReceiver;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class ConsumerDragonRefundReceiver extends AbstractSqlRedisReceiver {
    @Override
    protected String getRedisStreamKey() {
        return MQConst.DragonQueue.DRAGON_REFUND_KEY.getKey();
    }

    @Override
    protected String getRedisStreamGroup() {
        return MQConst.DragonQueue.DRAGON_REFUND_KEY.getGroup();
    }

//    @Override
//    public void onMessage(MapRecord<String, String, String> message) {
//        log.info("接受到来自redis REFUND 的消息");
//        log.info("message id " + message.getId());
//        log.info("stream " + message.getStream());
//        log.info("body " + message.getValue());
//        boolean result = this.consumerSqlDaoHandler(message.getValue().get("message"));
////        if(result){
//            log.info("consumer success delete message messageId:{} ",message.getId());
//            try {
////                stringRedisTemplate.multi();
//                stringRedisTemplate.opsForStream().acknowledge(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), message);
//                stringRedisTemplate.opsForStream().delete(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), message.getId());
////                stringRedisTemplate.exec();
//            } catch (Exception e) {
//                log.error("delete redis queue message Exception error: {} ",e);
//                log.error("delete redis queue message error messageId:{} errMsg:{}",message.getId(),e.getMessage());
//            }finally {
//                stringRedisTemplate.opsForStream().acknowledge(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), message);
//                stringRedisTemplate.opsForStream().delete(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), message.getId());
//            }
////        }
//    }
//
//    private boolean consumerSqlDaoHandler(String msg) {
//        try {
//            SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(msg, SqlMapping.SqlMessage.class);
//            log.debug("CONSUMER MSG ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
//            log.debug("CONSUMER MSG ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));
//            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
//            log.debug("CONSUMER MSG result of execution:{}", rstBatchSqls);
//            if (rstBatchSqls) {
//                return true;
//            }else{
//                sendMySqlRedis(msg);
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            log.error("CONSUMER MSG Exception error:{}", e);
//        }
//        return false;
//    }
//
//    /**
//     * 给 REDIS 队列发送消息 数据库相关
//     *
//     * @param msg 接收到的内容
//     * @return
//     */
//    private boolean sendMySqlRedis(String msg) {
//        try {
//            HashMap<String, String> map = new HashMap<>();
//            map.put("message", msg);
//            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode());
//            stringRedisTemplate.opsForStream().add(record);
//            return true;
//        } catch (Exception e) {
//            e.printStackTrace();
//            return false;
//        }
//    }
}