package com.liquidnet.service.dragon.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataUtils {
    @Autowired
    private RedisUtil redisUtil;

    private long keyExpireTime = 3600*24*30;

    public void createPayOrder(String code, DragonOrdersDto ordersDto) {
        redisUtil.set(DragonConstant.REDIS_KET_PAY_CODE + code, ordersDto,keyExpireTime);
    }

    public DragonOrdersDto getPayOrderByCode(String code) {
        Object obj = redisUtil.get(DragonConstant.REDIS_KET_PAY_CODE + code);
        if(obj!=null){
            return (DragonOrdersDto) obj;
        }
        return null;
    }

    public void updateOrderStatus(String code, DragonOrdersDto dragonOrdersDto) {
        redisUtil.set(DragonConstant.REDIS_KET_PAY_CODE + code, dragonOrdersDto,keyExpireTime);
    }

    public void setRefundNotifyUrl(String code, String notifyUrl) {
        redisUtil.set(DragonConstant.REFUND_REDIS_KET + code, notifyUrl,keyExpireTime);
    }
    /**
     * @author zhangfuxin
     * @Description:通过退款订单号找到 支付订单号
     * @date 2021/12/3 上午11:45
     */
    public void setOrderCode(String refundCode,String orderCode){
        redisUtil.set(DragonConstant.ORDERCODE_REDIS_KET + refundCode, orderCode,keyExpireTime);
    }
    public String getOrderCode(String refundCode){
        //redisUtil.set(DragonConstant.ORDERCODE_REDIS_KET + refundCode, orderCode,keyExpireTime);
        return (String) redisUtil.get(DragonConstant.ORDERCODE_REDIS_KET + refundCode);
    }

    public String getRefundNotifyUrl(String code) {
        return (String) redisUtil.get(DragonConstant.REFUND_REDIS_KET + code);
    }
}
