package com.liquidnet.service.goblin.dto.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.entity.GoblinNftExActivity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author: wll
 * @Description: nft 兑换活动表
 * @Date:Create：in 2022/4/19 2:14 下午
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftExActivityVo implements Serializable,Cloneable {


    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * 活动id
     */
    @ApiModelProperty(position = 10,required = true,value ="活动id")
    private String activityId;

    /**
     * 活动标题
     */
    @ExcelProperty(value = "活动标题", index = 0)//”0“表示excel中的第一列
    @ApiModelProperty(position = 11,required = true,value ="活动标题")
    private String title;

    /**
     * 创建时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 12,required = true,value ="创建时间")
    private LocalDateTime createdAt;



    /**
     * 更新时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 13,required = true,value ="更新时间")
    private LocalDateTime updatedAt;

    /**
     * 总数量
     */
    @ExcelProperty(value = "优惠券总数量", index = 2)//”0“表示excel中的第一列
    @ApiModelProperty(position = 14,required = true,value ="总数量")
    private Integer countNumber;

    /**
     * 使用数量
     */
    @ExcelProperty(value = "优惠券使用数量", index = 3)//”0“表示excel中的第一列
    @ApiModelProperty(position = 15,required = true,value ="使用数量")
    private Integer useNumber;

    /**
     * 未使用数量
     */
    @ExcelProperty(value = "兑换码未使用数量", index = 4)//”0“表示excel中的第一列
    @ApiModelProperty(position = 16,required = true,value ="未使用数量")
    private Integer unUseNumber;

    @ApiModelProperty(position = 17,required = true,value ="sku基本所属信息集合")
    private List<GoblinNftSkuVo> goblinNftSkuVos;

    /**
     *
     */
    @ApiModelProperty(position = 18,required = true,value ="是否展示生效中 0：否  1：是")
    private Integer isDisplay;


    private  final  static GoblinNftExActivityVo obj = new GoblinNftExActivityVo();

    public static GoblinNftExActivityVo getNew(){
        try {
            return  (GoblinNftExActivityVo) obj.clone();
        }catch (CloneNotSupportedException e){
            return new GoblinNftExActivityVo();
        }
    }

    public GoblinNftExActivityVo copy(GoblinNftExActivity goblinNftExActivity){
        if (null == goblinNftExActivity) return this;
        this.setActivityId(goblinNftExActivity.getActivityId());
        this.setTitle(goblinNftExActivity.getTitle());
        this.setCreatedAt(goblinNftExActivity.getCreatedAt());
        this.setUpdatedAt(goblinNftExActivity.getUpdatedAt());
        this.setCountNumber(goblinNftExActivity.getCountNumber());
        this.setUseNumber(goblinNftExActivity.getUseNumber());
        this.setUnUseNumber(goblinNftExActivity.getUnUseNumber());
        this.setIsDisplay(goblinNftExActivity.getIsDisplay());
        return this;
    }

}


