package com.liquidnet.service.galaxy.router.xuper.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyArtwork;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterArtworkHandler;
import com.liquidnet.service.galaxy.router.xuper.biz.XuperArtworkBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyXuperArtworkImpl
 * @Package com.liquidnet.service.galaxy.router.xuper.service
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:03
 */
@Slf4j
@Component
@StrategyGalaxyRouterArtworkHandler(GalaxyEnum.RouterTypeEnum.XUPER)
public class GalaxyRouterStrategyXuperArtworkImpl implements IGalaxyRouterStrategyArtwork {
    @Autowired
    private XuperArtworkBiz xuperArtworkBiz;

    @Override
    public ResponseDto<GalaxyNftImageRespDto> nftImageCheck(GalaxyNftImageReqDto reqDto) {
        return xuperArtworkBiz.nftImageCheck(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftUploadRespDto> nftUpload(GalaxyNftUploadReqDto reqDto) {
        return xuperArtworkBiz.nftUpload(reqDto);
    }

    @Override
    public ResponseDto<GalaxyArtSeriesClaimRespDto> seriesClaim(GalaxyArtSeriesClaimReqDto reqDto) {
        return xuperArtworkBiz.seriesClaim(reqDto);
    }

    @Override
    public ResponseDto<GalaxyArtSeriesClaimResultQueryRespDto> seriesClaimResultQuery(GalaxyArtSeriesClaimResultQueryReqDto reqDto) {
        return xuperArtworkBiz.seriesClaimResultQuery(reqDto);
    }
}