package com.liquidnet.service.stone.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.stone.constant.StoneConstant;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.vo.StoneUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class StoneRedisUtils {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private StoneMongoUtils mongoUtils;

    /**
     * 获取 积分物品 剩余库存
     *
     * @param itemId ID
     * @return
     */
    public Integer getStoneGeneralSurplus(String itemId) {
        String redisKey = StoneConstant.ITEM.concat(itemId).concat(StoneConstant.SURPLUS_GENERAL);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (Integer) obj;
        }
    }

    /**
     * 修改 积分物品 库存
     *
     * @param itemId  ID
     * @param general 改变量
     * @return
     */
    public Integer changeStoneGeneralSurplus(String itemId, Integer general) {
        String redisKey = StoneConstant.ITEM.concat(itemId).concat(StoneConstant.SURPLUS_GENERAL);
        long result;
        if (general > 0) {
            result = redisUtil.incr(redisKey, general);
        } else {
            result = redisUtil.decr(redisKey, Math.abs(general));
        }
        return (int) result;
    }

    /**
     * 获取 用户积分 可用
     *
     * @param uid  ID
     * @return
     */
    public Integer getUserScoreRest(String uid) {
        String redisKey = StoneConstant.USE_SCORE.concat(uid).concat(StoneConstant.SURPLUS_SCORE);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (Integer) obj;
        }
    }

    /**
     * 获取 用户积分 可用
     *
     * @param uid  ID
     * @return
     */
    public Integer getUserScoreUse(String uid) {
        String redisKey = StoneConstant.USE_SCORE.concat(uid).concat(StoneConstant.USE_SCORE);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (Integer) obj;
        }
    }

    /**
     * 设置 积分物品 缓存
     *
     * @param itemId
     * @param data
     */
    public void setItemData(String itemId, StoneScoreItems data) {
        String redisKey = StoneConstant.ITEM.concat(itemId);
        redisUtil.set(redisKey, data);
    }

    /**
     * 获取 积分物品 缓存
     *
     * @param itemId
     */
    public StoneScoreItems getItemData(String itemId) {
        String redisKey = StoneConstant.ITEM.concat(itemId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return mongoUtils.itemGet(itemId);
        } else {
            return (StoneScoreItems) obj;
        }
    }


    /**
     * 修改 积分物品 缓存list
     *
     * @param data
     */
    public void updateItemDataList(StoneScoreItems data) {
        String redisKey = StoneConstant.ITEM_LIST;
        Object obj = redisUtil.get(redisKey);
        List<StoneScoreItems> dataList;
        if (obj == null) {
            dataList = mongoUtils.itemList();
        } else {
            dataList = (List<StoneScoreItems>) obj;
        }
        for (int i = 0; i < dataList.size(); i++) {
            StoneScoreItems items = dataList.get(i);
            if (items.getItemId().equals(data.getItemId())) {
                dataList.set(i, items);
                break;
            }
        }
        redisUtil.set(redisKey, dataList);
    }

    /**
     * 添加 积分物品 缓存list
     *
     * @param data
     */
    public void addItemDataList(StoneScoreItems data) {
        String redisKey = StoneConstant.ITEM_LIST;
        Object obj = redisUtil.get(redisKey);
        List<StoneScoreItems> dataList;
        if (obj == null) {
            dataList = mongoUtils.itemList();
        } else {
            dataList = (List<StoneScoreItems>) obj;
        }
        dataList.add(0, data);
        if (dataList.size() > 40) {
            int size = dataList.size() - 40;
            for (int i = 0; i < size; i++) {
                dataList.remove(40);
            }
        }
        redisUtil.set(redisKey, dataList);
    }

    /**
     * 设置 积分物品 缓存list
     */
    public List<StoneScoreItems> getItemDataList() {
        String redisKey = StoneConstant.ITEM_LIST;
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return mongoUtils.itemList();
        } else {
            return (List<StoneScoreItems>) obj;
        }
    }

    /**
     * 设置 用户积分 缓存
     *
     * @param uid
     * @param data
     */
    public void setUserData(String uid, StoneUserVo data) {
        String redisKey = StoneConstant.USER.concat(uid);
        redisUtil.set(redisKey, data);
    }

    /**
     * 获取 用户积分 缓存
     *
     * @param uid
     */
    public StoneUserVo getUserData(String uid) {
        String redisKey = StoneConstant.USER.concat(uid);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (StoneUserVo) obj;
        }
    }

}
