package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamCollection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "AdamCollectVo", description = "收藏信息")
@Data
public class AdamCollectVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3222644230886542725L;
    @ApiModelProperty(position = 11, required = true, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 12, required = true, value = "内容类型")
    private String type;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @ApiModelProperty(position = 14, required = true, value = "展示信息")
    private AdamCollectInfoVo contentInfo;

    private static final AdamCollectVo obj = new AdamCollectVo();

    public static AdamCollectVo getNew() {
        try {
            return (AdamCollectVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamCollectVo();
        }
    }

    public AdamCollectVo copy(AdamCollection source) {
        if (null == source) return this;
        this.setContentId(source.getContentId());
        this.setType(source.getType());
        this.setCreatedAt(source.getCreatedAt());
        return this;
    }
}
