package com.liquidnet.service.goblin.mapper;

import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * 商品单品 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Repository
public interface GoblinGoodsSkuMapper extends BaseMapper<GoblinGoodsSku> {

    /**
     * 根据skuName获取
     * @param skuName
     * @return
     */
    List<GoblinGoodsSku> selectSkuLikeName(@Param("skuName") String skuName);

    /**
     * 根据skuIds查询sku
     * @param skuIds
     * @return
     */
    List<GoblinGoodsSku> selectByIds(@Param("skuIds") String skuIds);
}
