package com.liquidnet.service.consumer.sweet.config;

import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetStoneIntegralReceiver;
import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetTemplateMsgReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.SweetQueue.SWEET_TEMPLATE_MSG;
import static com.liquidnet.service.base.constant.MQConst.SweetQueue.SWEET_STONE_INTEGRAL;

@Configuration
public class ConsumerSweetOtherApiStreamConfig {
    @Autowired
    ConsumerSweetTemplateMsgReceiver consumerSweetTemplateMsgReceiver;
    @Autowired
    ConsumerSweetStoneIntegralReceiver consumerSweetStoneIntegralReceiver;

    private StreamMessageListenerContainer<String, MapRecord<String, String, String>> buildStreamMessageListenerContainer(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        return StreamMessageListenerContainer.create(factory, options);
    }

    /**
     * 模版消息
     */
    private Subscription receiveApiTemplateMsg(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(SWEET_TEMPLATE_MSG.getGroup(), SWEET_TEMPLATE_MSG.name() + t),
                StreamOffset.create(SWEET_TEMPLATE_MSG.getKey(), ReadOffset.lastConsumed()), consumerSweetTemplateMsgReceiver
        );
    }
    /**
     * 增减积分
     */
    private Subscription receiveApiStoneIntgral(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(SWEET_STONE_INTEGRAL.getGroup(), SWEET_STONE_INTEGRAL.name() + t),
                StreamOffset.create(SWEET_STONE_INTEGRAL.getKey(), ReadOffset.lastConsumed()), consumerSweetStoneIntegralReceiver
        );
    }

    /*----------------------------------------------------------------------------------------------------------------*/

    /*------------------模版消息------------------*/
    @Bean
    public Subscription subscriptionApiTemplateMsg(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveApiTemplateMsg(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionApiTemplateMsg2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveApiTemplateMsg(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionApiTemplateMsg3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveApiTemplateMsg(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    /*------------------增减积分------------------*/
    @Bean
    public Subscription subscriptionApiStoneIntgral(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveApiStoneIntgral(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionApiStoneIntgral2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveApiStoneIntgral(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionApiStoneIntgral3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveApiStoneIntgral(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }
}
