package com.liquidnet.service.candy.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.dto.CandyCouponInfoDto;
import com.liquidnet.service.candy.util.RedisDataUtils;
import com.liquidnet.service.candy.vo.CandyCouponBasicVo;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Api(tags = "@API:RSC")
@RestController
@Validated
@RequestMapping("rsc")
public class CandyRscController {
    @Autowired
    private RedisDataUtils redisDataUtils;

    @PostMapping("couinfo")
    @ApiOperation("券基础详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "couponId", value = "券ID", required = true),
    })
    public ResponseDto<CandyCouponBasicVo> couponListById(@RequestParam("couponId") @NotNull @NotBlank String couponId) {
        CandyCouponBasicVo couponBasicVo = CandyCouponBasicVo.getNew();
        CandyCouponInfoDto couponInfoDto = redisDataUtils.getCouponInfo(couponId);
        BeanUtils.copyProperties(couponInfoDto, couponBasicVo);
        return ResponseDto.success(couponBasicVo);
    }
}
