package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.param.SweetYbEnrollParam;
import com.liquidnet.service.sweet.dto.vo.SweetYbActivityVo;
import com.liquidnet.service.sweet.service.ISweetYbEnrollService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * YB报名表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-07-29
 */
@Api(tags = "YB")
@RestController
@RequestMapping("/yb")
public class SweetYbEnrollController {

    @Autowired
    private ISweetYbEnrollService iSweetYbEnrollService;

    @PostMapping("enroll")
    @ApiOperation("报名")
    public ResponseDto<Boolean> add(@Valid @RequestBody SweetYbEnrollParam param) {
        return iSweetYbEnrollService.create(param);
    }

    @PostMapping("activityList")
    @ApiOperation("活动列表")
    public ResponseDto<List<SweetYbActivityVo>> list() {
        return iSweetYbEnrollService.list();
    }
}
