package com.liquidnet.service.reconciliation.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 交易记录表
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class LrInfoflowLiquidnetAdam implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 编号，可重复
     */
    private String number;

    private String comId;

    /**
     * 交易类型
     */
    private String type;

    /**
     * 状态
     */
    private String status;

    /**
     * 币种
     */
    private String currency;

    /**
     * 金额
     */
    private BigDecimal fundAmount;

    /**
     * 出账/入账
     */
    private String fundDirection;

    /**
     * 关联订单id
     */
    private String relatedId;

    /**
     * 关联订单reference
     */
    private String relatedReference;

    /**
     * 银行交易id
     */
    private String bankTransactionId;

    /**
     * 银行渠道
     */
    private String bankChannel;

    /**
     * 钱包账号
     */
    private String finWalletNo;

    /**
     * 钱包名称
     */
    private String finWalletName;

    /**
     * 钱包交易id
     */
    private String finWalletTransactionId;

    /**
     * 钱包可用余额
     */
    private BigDecimal finWalletAvailableBalance;

    /**
     * 钱包总余额
     */
    private BigDecimal finWalletTotalBalance;

    /**
     * 失败原因
     */
    private String failureReason;

    /**
     * 完成时间
     */
    private LocalDateTime completeTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
