package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderTicketPreVo;
import com.liquidnet.service.kylin.dto.vo.returns.OrderRefundVo;
import com.liquidnet.service.kylin.service.impl.KylinOrderTicketsRefundServiceImpl;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * <p>
 * 订单用户申请退款 前端控制器
 * </p>
 *
 * @author 姜秀龙
 * @since 2021-09-16
 */
@Api(tags = "前端-订单相关")
@RestController
@RequestMapping("orderRefund")
@Validated
public class KylinOrderTicketsRefundController {

    @Autowired
    KylinOrderTicketsRefundServiceImpl kylinOrderTicketsRefundService;

    @GetMapping("toOrderRefundDetails")
    @ApiOperation("想要退款订单详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinOrderTicketPreVo> toOrderRefundDetails(
            @RequestParam(value = "orderId", required = false) @NotNull(message = "订单ID不能为空") String orderId
    ) {
        return kylinOrderTicketsRefundService.toOrderRefundDetails(orderId);
    }

    @PostMapping("sendOrderRefunds")
    @ApiOperation("发起退款申请")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "orderId", value = "订单ID", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "orderTicketEntitiesId", value = "订单入场人ID", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "reason", value = "退款申请备注", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "picList", value = "图片"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "ticketNum", value = "纸质票号"),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "sendExpressType", value = "快递方式 1上门取件 2自主发货"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "expressNumber", value = "自主发货的顺丰订单号"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "expressContacts", value = "发货人姓名"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "expressPhone", value = "发货人联系方式"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "sendExpressAddress", value = "取件地址"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "appointmentTime", value = "预约取件时间")
    })
    public ResponseDto sendOrderRefund(
            @RequestParam(value = "orderId", required = true) @NotNull(message = "订单ID不能为空") String orderId,
            @RequestParam(value = "orderTicketEntitiesId", required = true) @NotNull(message = "票单ID不能为空") String orderTicketEntitiesId,
            @RequestParam(value = "reason", required = true) @NotNull(message = "退款原因不能为空") String reason,
            @RequestParam(value = "picList", required = false) String picList,
            @RequestParam(value = "ticketNum", required = false) String ticketNum,

            @RequestParam(value = "sendExpressType", required = false) Integer sendExpressType,
            @RequestParam(value = "expressNumber", required = false) String expressNumber,

            @RequestParam(value = "expressContacts", required = false) String expressContacts,
            @RequestParam(value = "expressPhone", required = false) String expressPhone,
            @RequestParam(value = "sendExpressAddress", required = false) String sendExpressAddress,
            @RequestParam(value = "appointmentTime", required = false) String appointmentTime
    ) {
        // 退款
        return kylinOrderTicketsRefundService.sendOrderRefund(
                orderId, orderTicketEntitiesId, reason, picList, ticketNum,
                sendExpressType, expressNumber, expressContacts, expressPhone, sendExpressAddress, appointmentTime
        );
    }

    @GetMapping("orderRefundDetails")
    @ApiOperation("退款申请详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<OrderRefundVo> orderRefundDetails(@RequestParam(value = "orderId", required = true) @NotNull(message = "订单ID不能为空") String orderId,
                                                         @RequestParam(value = "orderRefundId", required = true) @NotNull(message = "退款订单ID不能为空") String orderRefundId) {
        return kylinOrderTicketsRefundService.orderRefundDetails(orderId, orderRefundId);
    }

    @PostMapping("orderRefundWithdraw")
    @ApiOperation("发起退款撤回")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> orderRefundWithdraw(@RequestParam(value = "orderRefundId", required = true) @NotNull(message = "退款订单ID不能为空") String orderRefundId) {
        return kylinOrderTicketsRefundService.orderRefundWithdraw(orderRefundId);
    }

}
