package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSkuListVo;
import com.liquidnet.service.goblin.service.IGoblinNftGoodsAppService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

@Slf4j
@Api(tags = "NFT商品-App")
@RestController
@Validated
@RequestMapping("/nftGoods")
public class GoblinNftGoodsAppController {

    @Autowired
    IGoblinNftGoodsAppService goblinNftGoodsAppService;
    @Autowired
    GoblinRedisUtils redisUtils;


    @GetMapping("list")
    @ApiOperation("获得NFT商品列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "page", value = "页码", example = "1"),
    })
    public ResponseDto<PagedResult<GoblinNftGoodsSkuListVo>> getGoodsList(
            @RequestParam(name = "page", defaultValue = "1") Integer page
    ) {
        return goblinNftGoodsAppService.goodsList(page);
    }

    @GetMapping("detail")
    @ApiOperation("获得商品详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", required = true, dataType = "String", name = "skuId", value = "skuId", example = "1"),
    })
    public ResponseDto<GoblinNftGoodsSkuInfoVo> getGoodsDetail(
            @RequestParam("skuId") @NotBlank(message = "skuId不能为空") String skuId
    ) {
        GoblinNftGoodsSkuInfoVo vo = goblinNftGoodsAppService.goodsDetail(skuId);
        if (vo == null) {
            return ResponseDto.failure("商品不存在");
        }
        return ResponseDto.success(vo);
    }

    @PostMapping("exchange")
//    @ApiOperation("兑换")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "from", required = true, dataType = "String", name = "code", value = "兑换码", example = "1"),
    })
    public ResponseDto exchange(
            @RequestParam("code") String code
    ) {
        Boolean res = goblinNftGoodsAppService.exchange(code);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure();
        }
    }

    @PostMapping("payType")
    @ApiOperation("设置payType")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "from", required = true, dataType = "String", name = "value", value = "状态[0-苹果支付|1-微信支付宝]", example = "1"),
    })
    public ResponseDto<Boolean> setPayType(@RequestParam("value") Integer value) {
        redisUtils.setPayType(value);
        return ResponseDto.success();
    }

    @GetMapping("payType")
    @ApiOperation("获取payType")
    public ResponseDto<Integer> getPayType() {
        return ResponseDto.success(redisUtils.getPayType());
    }
}
