package com.liquidnet.service.galaxy.biz;

import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyTransferNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftTransferQueryRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftTransferReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftTransferRespDto;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftOrderFailLogVo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftTradeVo;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyCommonBiz
 * @Package com.liquidnet.service.galaxy.router.strategy.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/23 11:20
 */
@Slf4j
@Component
public class GalaxyBeanTransferBiz {
    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private GalaxyDataUtils dataUtils;

    public GalaxyNftOrderBo buildNftOrderBo(String nftOrderPayId, GalaxyUserInfoBo userInfoBo, GalaxySeriesNftInfoBo seriesNftInfoBo){
        GalaxyNftOrderBo nftOrderBo = GalaxyNftOrderBo.getNew();
        nftOrderBo.setUserId(userInfoBo.getUserId());
        nftOrderBo.setSkuId(seriesNftInfoBo.getSkuId());
        nftOrderBo.setSeriesName(seriesNftInfoBo.getSeriesName());
        nftOrderBo.setSeriesId(seriesNftInfoBo.getSeriesId());
        nftOrderBo.setSeriesCode(seriesNftInfoBo.getSeriesCode());
        nftOrderBo.setNftOrderPayId(nftOrderPayId);
        nftOrderBo.setNftId(null);
        nftOrderBo.setNftName(seriesNftInfoBo.getNftName());
        nftOrderBo.setNftPrice(seriesNftInfoBo.getSellCount().longValue());
        nftOrderBo.setNftPublishTaskId(null);
        nftOrderBo.setNftPublishFromAddress(zxlnftConfig.getNftPlatformAddress());
        nftOrderBo.setNftPublishToAddress("NFT");
        nftOrderBo.setNftPublishChainTimestamp(null);
        nftOrderBo.setNftPublishStatus(GalaxyEnum.TaskStatusEnum.INIT.getCode());
        nftOrderBo.setNftPublishTradeHash(null);
        nftOrderBo.setNftBuyTaskId(null);
        nftOrderBo.setNftBuyFromAddress(zxlnftConfig.getNftPlatformAddress());
        nftOrderBo.setNftBuyToAddress(userInfoBo.getBlockChainAddress());
        nftOrderBo.setNftBuyChainTimestamp(null);
        nftOrderBo.setNftBuyStatus(GalaxyEnum.TaskStatusEnum.INIT.getCode());
        nftOrderBo.setNftBuyTradeHash(null);
        nftOrderBo.setNftBuyPayTaskId(null);
        nftOrderBo.setRouterType(seriesNftInfoBo.getRouterType());
        nftOrderBo.setCreatedAt(LocalDateTime.now());
        nftOrderBo.setUpdatedAt(null);
        return nftOrderBo;
    }

    /**
     *
     * @param reqDto
     * @param userInfoBo
     * @param seriesNftInfoBo
     * @return
     */
    public GalaxyNftOrderFailLogVo buildNftOrderFailLogVo(GalaxyEnum.TradeTypeEnum tradeTypeEnum,GalaxyNftPublishAndBuyReqDto reqDto
            ,GalaxyEnum.OrderDealWithStatusEnum orderDealWithStatus,String failDesc,String failDescSecond,GalaxyUserInfoBo userInfoBo, GalaxySeriesNftInfoBo seriesNftInfoBo, GalaxyNftOrderBo nftOrderBo){
        GalaxyNftOrderFailLogVo nftOrderFailLogVo = GalaxyNftOrderFailLogVo.getNew();
        nftOrderFailLogVo.setNftOrderPayId(reqDto.getNftOrderPayId());

        if(StringUtil.isNotNull(seriesNftInfoBo)){
            nftOrderFailLogVo.setUserId(seriesNftInfoBo.getSkuId());
            nftOrderFailLogVo.setNftName(seriesNftInfoBo.getNftName());
            nftOrderFailLogVo.setSeriesName(seriesNftInfoBo.getSeriesName());
            nftOrderFailLogVo.setSeriesId(seriesNftInfoBo.getSeriesId());
            nftOrderFailLogVo.setSeriesCode(seriesNftInfoBo.getSeriesCode());
        }

        if(StringUtil.isNotNull(nftOrderBo)){
            nftOrderFailLogVo.setNftId(nftOrderBo.getNftId());
            if(tradeTypeEnum.getCode().equalsIgnoreCase(GalaxyEnum.TradeTypeEnum.TRADE_PUBLISH.getCode())){
                nftOrderFailLogVo.setTaskId(nftOrderBo.getNftPublishTaskId());
            }else if(tradeTypeEnum.getCode().equalsIgnoreCase(GalaxyEnum.TradeTypeEnum.TRADE_BUY.getCode())){
                nftOrderFailLogVo.setTaskId(nftOrderBo.getNftBuyTaskId());
            }
        }
        nftOrderFailLogVo.setFailReasonDesc(failDesc);
        nftOrderFailLogVo.setFailReasonDescSecond(failDescSecond);
        nftOrderFailLogVo.setDealWithStatus(orderDealWithStatus.getCode());
        nftOrderFailLogVo.setTradeType(tradeTypeEnum.getCode());
        nftOrderFailLogVo.setRouterType(reqDto.getRouterType());
        nftOrderFailLogVo.setCreatedAt(LocalDateTime.now());
        nftOrderFailLogVo.setUpdatedAt(null);
        return nftOrderFailLogVo;
    }

    /**
     * 构建nft交易vo
     * @param tradeTypeEnum
     * @param nftOrderBo
     * @return
     */
    public static GalaxyNftTradeVo buildNftTradeVo(GalaxyEnum.TradeTypeEnum tradeTypeEnum,GalaxyNftOrderBo nftOrderBo){
        GalaxyNftTradeVo nftTradeVo = GalaxyNftTradeVo.getNew();
        nftTradeVo.setUserId(nftOrderBo.getUserId());
        nftTradeVo.setNftId(nftOrderBo.getNftId());
        nftTradeVo.setNftName(nftOrderBo.getNftName());
        nftTradeVo.setSeriesName(nftOrderBo.getSeriesName());
        nftTradeVo.setSeriesId(nftOrderBo.getSeriesId());
        nftTradeVo.setSeriesCode(nftOrderBo.getSeriesCode());
        if(tradeTypeEnum.getCode().equalsIgnoreCase(GalaxyEnum.TradeTypeEnum.TRADE_PUBLISH.getCode())){
            nftTradeVo.setTradeHash(nftOrderBo.getNftPublishTradeHash());
            nftTradeVo.setChainTimestamp(nftOrderBo.getNftPublishChainTimestamp());
            nftTradeVo.setFromAddress(nftOrderBo.getNftPublishFromAddress());
            nftTradeVo.setToAddress(nftOrderBo.getNftPublishToAddress());
            nftTradeVo.setTradePrice(0l);
            nftTradeVo.setTradeType(tradeTypeEnum.getCode());
        }else if(tradeTypeEnum.getCode().equalsIgnoreCase(GalaxyEnum.TradeTypeEnum.TRADE_BUY.getCode())){
            nftTradeVo.setTradeHash(nftOrderBo.getNftBuyTradeHash());
            nftTradeVo.setChainTimestamp(nftOrderBo.getNftBuyChainTimestamp());
            nftTradeVo.setFromAddress(nftOrderBo.getNftBuyFromAddress());
            nftTradeVo.setToAddress(nftOrderBo.getNftBuyToAddress());
            nftTradeVo.setTradePrice(nftOrderBo.getNftPrice());
            nftTradeVo.setTradeType(tradeTypeEnum.getCode());
        }
        nftTradeVo.setRouterType(nftOrderBo.getRouterType());
        nftTradeVo.setCreatedAt(DateUtil.getNowTime());
        return nftTradeVo;
    }

    /**
     * 构造nft转让信息
     * @param reqDto
     * @param userInfoBo
     * @param receiveUserInfoBo
     * @return
     */
    public GalaxyTransferNftInfoBo buildTransferNftInfoBo(GalaxyNftTransferReqDto reqDto,GalaxyUserInfoBo userInfoBo,GalaxyUserInfoBo receiveUserInfoBo){
        GalaxyTransferNftInfoBo transferNftInfoBo = GalaxyTransferNftInfoBo.getNew();
        transferNftInfoBo.setTransOrderId(reqDto.getTransOrderId());
        transferNftInfoBo.setNftId(reqDto.getNftId());
        transferNftInfoBo.setUserId(reqDto.getUserId());
        transferNftInfoBo.setAddress(userInfoBo.getBlockChainAddress());
        transferNftInfoBo.setReceiveUserId(reqDto.getReceiveUserId());
        transferNftInfoBo.setReceiveAddress(receiveUserInfoBo.getBlockChainAddress());
        transferNftInfoBo.setOwnerUserId(null);
        transferNftInfoBo.setOwnerAddress(null);
        transferNftInfoBo.setSeriesId(null);
        transferNftInfoBo.setRouterType(reqDto.getRouterType());
        transferNftInfoBo.setTransferStatus(GalaxyEnum.NftTransferStatusEnum.INIT.getCode());
        transferNftInfoBo.setNftTransferTaskId(null);
        transferNftInfoBo.setNftTransferChainTimestamp(null);
        transferNftInfoBo.setTransferHash(null);
        transferNftInfoBo.setErrorCode(null);
        transferNftInfoBo.setErrorMsg(null);
        transferNftInfoBo.setCreatedAt(DateUtil.getNowTime());
        transferNftInfoBo.setUpdatedAt(null);
        return transferNftInfoBo;
    }

    /**
     *  构造nft转让返回结果
     * @param reqDto
     * @param userInfoBo
     * @param receiveUserInfoBo
     * @return
     */
    public GalaxyNftTransferRespDto buildNftTransferRespDto(GalaxyNftTransferReqDto reqDto,GalaxyUserInfoBo userInfoBo,GalaxyUserInfoBo receiveUserInfoBo,GalaxyTransferNftInfoBo transferNftInfoBo){
        GalaxyNftTransferRespDto respDto = GalaxyNftTransferRespDto.getNew();
        respDto.setNftId(reqDto.getNftId());
        respDto.setOwnerUserId(receiveUserInfoBo.getUserId());
        respDto.setOwnerAddress(receiveUserInfoBo.getBlockChainAddress());
        respDto.setFromUserId(userInfoBo.getUserId());
        respDto.setFromAddress(userInfoBo.getBlockChainAddress());
        respDto.setTransferTime(DateUtil.getNowTime());
        respDto.setRouterType(transferNftInfoBo.getRouterType());
        respDto.setTransferHash(transferNftInfoBo.getTransferHash());
        return respDto;
    }

    /**
     * 构造nft转让结果查询
     * @param transferNftInfoBo
     * @return
     */
    public GalaxyNftTransferQueryRespDto buildNftTransferQueryRespDto(GalaxyTransferNftInfoBo transferNftInfoBo){
        GalaxyNftTransferQueryRespDto nftTransferQueryRespDto = GalaxyNftTransferQueryRespDto.getNew();
        nftTransferQueryRespDto.setNftId(transferNftInfoBo.getNftId());
        nftTransferQueryRespDto.setOwnerUserId(transferNftInfoBo.getOwnerUserId());
        nftTransferQueryRespDto.setOwnerAddress(transferNftInfoBo.getOwnerAddress());
        nftTransferQueryRespDto.setFromUserId(transferNftInfoBo.getUserId());
        nftTransferQueryRespDto.setFromAddress(transferNftInfoBo.getAddress());
        nftTransferQueryRespDto.setTransferTime(transferNftInfoBo.getCreatedAt());
        nftTransferQueryRespDto.setRouterType(transferNftInfoBo.getRouterType());
        nftTransferQueryRespDto.setTransferHash(transferNftInfoBo.getTransferHash());
        return nftTransferQueryRespDto;
    }
}
