package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberCodeParam", description = "添加编辑会员兑换码")
@Data
public class AdamMemberCodeParam implements Serializable {
    private static final long serialVersionUID = -7273522103593077617L;
    @ApiModelProperty(position = 1, required = false, value = "会员类型ID")
    private String memberId;
    @ApiModelProperty(position = 2, required = false, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(position = 3, required = true, value = "类型:0-用户购买兑换码,1-后台生成兑换码", example = "0")
    private Integer type;
    @ApiModelProperty(position = 4, required = false, value = "用户ID", example = "1")
    private String buyUid;

}
