package com.liquidnet.service.feign.adam.api;

import com.liquidnet.service.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-adam",
        contextId = "sev-adam-auth", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamAuthClient {

    @PostMapping(value =  "login")
    ResponseDto<Object> loginByPwd(@RequestParam String mobile, @RequestParam String password);

}
