package com.liquidnet.service.adam.common;

import com.liquidnet.common.exception.properties.ErrorCodeProperties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: AdamErrorCode
 * @Package com.liquidnet.service.adam.constant
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/22 11:43
 */
public enum AdamErrorCode {
    SUCCESS("0"),
    ADAM001_SYSTEM_ERROR("ADAM0010001"),
    ADAM001_PARAM_ERROR("ADAM0010002"),
    ADAM001_ILLEGAL_PARAM("ADAM0010003"),
    ADAM001_ILLEGAL_OPERATION("ADAM0010004"),
    ADAM001_OPERATION_FAILED("ADAM0010005"),
    ADAM001_REPEAT_SUBMIT("ADAM0010006"),
    ADAM001_VERIFYCODE_EXPIRED("ADAM0010007"),
    ADAM001_VERIFYCODE_ERROR("ADAM0010008"),
    ADAM001_VERIFYCODE_SENT("ADAM0010009"),



    PWD_FORMAT_INVALID("ADAM0020001"),
    EMAIL_FORMAT_INVALID("ADAM0020002"),
    COM_HAS_SIGNED("ADAM0020003"),
    EMAIL_HAS_REGIS("ADAM0020004"),
    EMAIL_HAS_REGIS_VER("ADAM0020005"),
    NAME_LOST("ADAM0020006"),
    JOB_TITLE_LOST("ADAM0020007"),
    EMAIL_LOST("ADAM0020008"),
    PASSWORD_LOST("ADAM0020009"),
    COMPANY_LOST("ADAM0020010"),
    INVALID_AUTH_ADDRESS("ADAM0020011"),
    TOKEN_EXPIRED_OR_BROKEN("ADAM0020012"),
    EMAIL_NOT_REGIS("ADAM0020013"),
    EMAIL_NOT_ACTIVATED("ADAM0020014"),
    VERIF_NOT_PASSED("ADAM0020015"),
    ADAM_USER_PW_0020016("ADAM_USER_PW_0020016"),
    ILLEGAL_VERIF_CODE("ADAM0020017"),
    WRONG_VERIF_CODE("ADAM0020018"),
    PARAM_ERROR("ADAM0020020"),
    PHONE_NUMBER_EXIST("ADAM0020021"),
    ILLEGAL_PARAM("ADAM0020022"),
    PASSWORD_RESET_REJECT("ADAM0020023"),
    PHONE_AUTH_PASSED("ADAM0020024"),
    ADAM_USER_EMAIL_REGISTERED("ADAM0020025"),
    ADAM_USER_PASSWORD_FORGET_PHONE("ADAM0020026"),
    ADAM_USER_PASSWORD_ERROR_5("ADAM0020027"),
    ADAM_USER_PASSWORD_ERROR_7("ADAM0020028"),
    ADAM_USER_HAS_BEEN_ACTIVATED("ADAM0020029"),
    ADAM_USER_HAS_BEEN_REMOVED("ADAM0020030"),




    // Company
    ADAM_COM_0030001("ADAM_COM_0030001"),
    ADAM_COM_0030002("ADAM_COM_0030002"),
    ADAM_COM_0030003("ADAM_COM_0030003"),
    ADAM_COM_0030004("ADAM_COM_0030004"),
    ADAM_COM_0030005("ADAM_COM_0030005"),
    // Account
    ADAM_ACCOUNT_004001("ADAM_ACCOUNT_004001"),
    ADAM_ACCOUNT_004002("ADAM_ACCOUNT_004002"),
    ADAM_ACCOUNT_004003("ADAM_ACCOUNT_004003"),
    ADAM_ACCOUNT_004004("ADAM_ACCOUNT_004004"),

    // Wallet
    ADAM_WALLET_005001("ADAM_WALLET_005001"),
    ADAM_WALLET_005002("ADAM_WALLET_005002"),
    ADAM_WALLET_005003("ADAM_WALLET_005003"),
    ADAM_WALLET_005004("ADAM_WALLET_005004"),
    ADAM_WALLET_005005("ADAM_WALLET_005005"),

    // Payout
    ADAM_PAYOUT_006001("ADAM_PAYOUT_006001"),
    ADAM_PAYOUT_006002("ADAM_PAYOUT_006002"),
    ADAM_PAYOUT_006003("ADAM_PAYOUT_006003"),
    ADAM_PAYOUT_006004("ADAM_PAYOUT_006004"),
    ADAM_PAYOUT_006005("ADAM_PAYOUT_006005"),
    ADAM_PAYOUT_006006("ADAM_PAYOUT_006006"),
    ADAM_PAYOUT_006007("ADAM_PAYOUT_006007"),
    ADAM_PAYOUT_006008("ADAM_PAYOUT_006008"),
    ADAM_PAYOUT_006009("ADAM_PAYOUT_006009"),
    ADAM_PAYOUT_006010("ADAM_PAYOUT_006010"),

    // Funding
    ADAM_FUNDING_007001("ADAM_FUNDING_007001"),

    // Conversion
    ADAM_CONVERSION_008001("ADAM_CONVERSION_008001"),
    ADAM_CONVERSION_008002("ADAM_CONVERSION_008002"),
    ADAM_CONVERSION_008003("ADAM_CONVERSION_008003"),
    ADAM_CONVERSION_008004("ADAM_CONVERSION_008004"),
    ADAM_CONVERSION_008005("ADAM_CONVERSION_008005"),
    ADAM_CONVERSION_008006("ADAM_CONVERSION_008006"),


    // Transaction
    ADAM_TRANSACTION_008001("ADAM_TRANSACTION_008001"),

    // Administration
    ADAM_ADMINISTRATION_009001("ADAM_ADMINISTRATION_009001"),
    ADAM_ADMINISTRATION_009002("ADAM_ADMINISTRATION_009002"),
    ADAM_ADMINISTRATION_009003("ADAM_ADMINISTRATION_009003"),
    ADAM_ADMINISTRATION_009004("ADAM_ADMINISTRATION_009004"),
    ADAM_ADMINISTRATION_009005("ADAM_ADMINISTRATION_009005"),

    // FEGIN Account
    ADAM_FEGIN_ACCOUNT_100001("ADAM_FEGIN_ACCOUNT_100001"),

    // FEGIN Bank cc
    ADAM_FEGIN_BANK_CC_200001("ADAM_FEGIN_BANK_CC_200001"),
    ;

    AdamErrorCode(String code) {
        this.code = code;
    }

    private String code;

    private static final Map<String, AdamErrorCode> valueMap;

    static {
        Map<String, AdamErrorCode> errorMap = new HashMap<>();
        for (AdamErrorCode errorCode : AdamErrorCode.values()) {
            errorMap.put(errorCode.code, errorCode);
        }
        valueMap = Collections.unmodifiableMap(errorMap);
    }

    public static AdamErrorCode getErrorCode(String code) {
        return valueMap.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getVal() {
        return ErrorCodeProperties.getValue(this.code);
    }
}
