package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamUserInfoVo", description = "用户详情")
@Data
public class AdamUserInfoVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 8479869354894030303L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "昵称[32]")
    private String username;
    @ApiModelProperty(position = 12, value = "性别[32]")
    private String sex;
    @ApiModelProperty(position = 13, value = "生日[YYYY-MM-DD]")
    private String birthday;
    @ApiModelProperty(position = 14, value = "常住地/区域")
    private String area;
    @ApiModelProperty(position = 15, value = "个性签名")
    private String signature;
    @ApiModelProperty(position = 16, value = "头像")
    private String avatar;
    @ApiModelProperty(position = 17, value = "背景图")
    private String background;
    @ApiModelProperty(position = 18, value = "标签")
    private String tagMe;
    @ApiModelProperty(position = 19, value = "")
    private String rongCloudToken;
//    @ApiModelProperty(position = 20, value = "隐私配置")
//    private

    private static final AdamUserInfoVo obj = new AdamUserInfoVo();

    public static AdamUserInfoVo getNew() {
        try {
            return (AdamUserInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserInfoVo();
    }
}
