package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 轮播图 banner 搜索 需要的参数
 * </p>
 * @author jiangxiulong
 * @since 2021-05-03 11:19 上午
 */

@Data
public class BannersSearchParam implements Serializable {
    @ApiModelProperty(value = "标题", example = "这是一个banner标题")
    private String bannersName;

    @ApiModelProperty(value = "跳转类型(由接口提供)", example = "6")
    private Integer targetType;

    @ApiModelProperty(value = "是否上线展示 0下线 1上线", example = "1", allowableValues = "0,1")
    private Integer isOnline;

    @ApiModelProperty(value = "推广类型 1全国 2省份", example = "1", allowableValues = "1,2")
    private Integer promotionType;

    @ApiModelProperty(value = "页数 ", example = "1")
    private int page;

    @ApiModelProperty(value = "数量 ", example = "10")
    private int size;
}
