package com.liquidnet.service.galaxy.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.aop.annotation.ControllerLog;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftBuyReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftBuyRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyTradeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT购买
 * @class: GalaxyNftTradeController
 * @Package com.liquidnet.service.galaxy.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 18:08
 */
@Api(tags = "NFT交易相关")
@RestController
@RequestMapping("nftTrade")
@Validated
@Slf4j
public class GalaxyTradeController {
    @Autowired
    private IGalaxyTradeService galaxyTradeService;

    @ControllerLog(description = "NFT购买")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT购买")
    @PostMapping(value = {"nftBuy"})
    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(@Valid @RequestBody GalaxyNftBuyReqDto reqDto){
        return galaxyTradeService.nftBuy(reqDto);
    }

    @ControllerLog(description = "NFT购买(发行+购买)")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT购买(发行+购买)")
    @PostMapping(value = {"nftPublishAndBuy"})
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(@Valid @RequestBody GalaxyNftPublishAndBuyReqDto reqDto){
        return galaxyTradeService.nftPublishAndBuy(reqDto);
    }
}
