package com.liquidnet.service.galaxy.router.strategy;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyContext
 * @Package com.liquidnet.service.galaxy.router.strategy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/8 11:26
 */
@Component
public class GalaxyRouterStrategyContext {
    private final Map<String, IGalaxyRouterStrategyArtwork> artworkHandlerMap = new HashMap<>();
    private final Map<String, IGalaxyRouterStrategyUser> userHandlerMap = new HashMap<>();
    private final Map<String, IGalaxyRouterStrategyPublish> publishHandlerMap = new HashMap<>();
    private final Map<String, IGalaxyRouterStrategyTrade> tradeHandlerMap = new HashMap<>();

    public IGalaxyRouterStrategyArtwork getArtworkStrategy(String type) {
        return artworkHandlerMap.get(type);
    }

    public void putArtworkStrategy(String code, IGalaxyRouterStrategyArtwork strategy) {
        artworkHandlerMap.put(code, strategy);
    }

    public IGalaxyRouterStrategyUser getUserStrategy(String type) {
        return userHandlerMap.get(type);
    }

    public void putUserStrategy(String code, IGalaxyRouterStrategyUser strategy) {
        userHandlerMap.put(code, strategy);
    }

    public IGalaxyRouterStrategyPublish getPublishStrategy(String type) {
        return publishHandlerMap.get(type);
    }

    public void putPublishStrategy(String code, IGalaxyRouterStrategyPublish strategy) {
        publishHandlerMap.put(code, strategy);
    }

    public IGalaxyRouterStrategyTrade getTradeStrategy(String type) {
        return tradeHandlerMap.get(type);
    }

    public void putTradeStrategy(String code, IGalaxyRouterStrategyTrade strategy) {
        tradeHandlerMap.put(code, strategy);
    }
}
