package com.liquidnet.service.kylin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.kylin.entity.KylinLackRegisters;
import com.liquidnet.service.kylin.mapper.KylinLackRegistersMapper;
import com.liquidnet.service.kylin.service.IKylinLackRegistersService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Map;

@Service
public class KylinLackRegistersServiceImpl extends ServiceImpl<KylinLackRegistersMapper, KylinLackRegisters> implements IKylinLackRegistersService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public ResponseDto<String> addLackRegister(String performanceId, String ticketId) {
        try {
            KylinLackRegisters lackRegisters = new KylinLackRegisters();
            Map token = CurrentUtil.getTokenClaims();
            lackRegisters.setLackRegistersId(IDGenerator.nextSnowId().toString());
            lackRegisters.setPerformanceId(performanceId);
            lackRegisters.setTicketId(ticketId);
            lackRegisters.setUserId(CurrentUtil.getCurrentUid());
            lackRegisters.setUserName(StringUtils.defaultString(((String) token.get("nickname")), ""));
            lackRegisters.setUserMobile(StringUtils.defaultString(((String) token.get("mobile")), ""));
            lackRegisters.setIpAddress(CurrentUtil.getCliIpAddr());
            lackRegisters.setCreatedAt(LocalDateTime.now());
            rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                    SqlMapping.get("kylin_order_ticket_status.close", lackRegisters.getInsertObj()));
            return ResponseDto.success("登记成功");
        }catch (Exception e){
            return ResponseDto.success("登记失败");
        }
    }
}
