package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.dto.vo.*;
import com.liquidnet.service.adam.entity.AdamEnters;

import java.util.List;

public interface IAdamRdmService {
    boolean setUidByMobile(String mobile, String uid);

    String getUidByMobile(String mobile);

    void delUidByMobile(String mobile);

    boolean setUidByPlatformOpenId(String platform, String openId, String uid);

    String getUidByPlatformOpenId(String platform, String openId);

    void delUidByPlatformOpenId(String platform, String openId);

    boolean setUserInfoVoByUid(String uid, AdamUserInfoVo vo);

    AdamUserInfoVo getUserInfoVoByUid(String uid);

    void delUserInfoVoByUid(String uid);

    boolean setRealInfoVoByUid(String uid, AdamRealInfoVo vo);

    AdamRealInfoVo getRealInfoVoByUid(String uid);

    void delRealInfoVoByUid(String uid);

    boolean setThirdPartVoListByUid(String uid, List<AdamThirdPartInfoVo> voList);

    List<AdamThirdPartInfoVo> getThirdPartVoListByUid(String uid);

    AdamThirdPartInfoVo getThirdPartVoByUidPlatform(String uid, String platform);

    void delThirdPartVoListByUid(String uid);

    boolean setEntersByUid(String uid, List<AdamEnters> list);

    List<AdamEnters> getEntersByUid(String uid);

    AdamEnters getEntersByUidEntersId(String uid, String entersId);

    void delEntersByUid(String uid);

    boolean setAddressesByUid(String uid, List<AdamAddressesVo> list);

    List<AdamAddressesVo> getAddressesByUid(String uid);

    AdamAddressesVo getAddressesByUidAddressesId(String uid, String addressesId);

    void delAddressesByUid(String uid);

    boolean setUserMemberVoByUid(String uid, AdamUserMemberVo vo);

    AdamUserMemberVo getUserMemberVoByUid(String uid);

    void delUserMemberVoByUid(String uid);

    AdamMemberSimpleVo getMemberSimpleVo();

    AdamMemberVo getMemberVoByMemberId(String memberId);

    boolean setMemberPriceVoByMemberId(String memberId, List<AdamMemberPriceVo> vos);

    List<AdamMemberPriceVo> getMemberPriceVoByMemberId(String memberId);

    AdamMemberPriceVo getMemberPriceVoByPriceId(String memberId, String memberPriceId);

    boolean setMemberRightsVoByMemberId(String memberId, List<AdamMemberRightsVo> vos);

    List<AdamMemberRightsVo> getMemberRightsVoByMemberId(String memberId);

    String getMemberAgreement();

    boolean setShotMemberOrderVoByOrderNo(String orderNo, AdamMemberOrderVo vo);

    AdamMemberOrderVo getShotMemberOrderVoByOrderNo(String orderNo);

    void delShotMemberOrderVoByOrderNo(String orderNo);

    boolean setMemberNoByMemberId(String memberId, long val);

    long incrMemberNoByMemberId(String memberId);

    Object getMemberMaxNoByMemberId(String memberId);

    boolean setMemberCodeVoByCode(String memberCode, AdamMemberCodeVo vo);

    AdamMemberCodeVo getMemberCodeVoByCode(String memberCode);

    boolean setTagsForSex(List<AdamTagVo> voList);

    List<AdamTagVo> getTagsForSex();

    boolean setTagsForMusic(List<AdamTagParentVo> voList);

    List<AdamTagParentVo> getTagsForMusic();
}
