package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.entity.SweetCityVote;
import com.liquidnet.service.sweet.mapper.SweetCityVoteMapper;
import com.liquidnet.service.sweet.param.SweetCityVoteParam;
import com.liquidnet.service.sweet.service.ISweetCityVoteService;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetCItyVoteStatVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 答题表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-12
 */
@Service
public class SweetCityVoteServiceImpl extends ServiceImpl<SweetCityVoteMapper, SweetCityVote> implements ISweetCityVoteService {

    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<List<SweetCItyVoteStatVo>> getList() {
        List<SweetCItyVoteStatVo> sweetCityVoteStatList = redisDataUtils.getSweetCityVoteStatList();
        return ResponseDto.success(sweetCityVoteStatList);
    }

    @Override
    public ResponseDto<Boolean> createVote(SweetCityVoteParam param) {
        SweetCityVote aNew = SweetCityVote.getNew();
        aNew.setVoteId(IDGenerator.nextSnowId());
        aNew.setPhone(param.getPhone());
        aNew.setUnionId(param.getUnionId());
        aNew.setCityCode(param.getCityCode());
        aNew.setCityName(param.getCityName());


        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsDataB = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_city_vote.insert"));
        sqlsDataA.add(new Object[]{
                aNew.getVoteId(), aNew.getPhone(), aNew.getUnionId(), aNew.getCityCode(), aNew.getCityName()
        });
        Integer cityVoteNum = redisDataUtils.getSweetCityVote(aNew.getCityCode());
        if (cityVoteNum > 0) { // 已有 incr
            sqls.add(SqlMapping.get("sweet_city_vote_stat.update"));
            sqlsDataB.add(new Object[]{
                    LocalDateTime.now(), aNew.getCityCode()
            });
        } else { // insert
            sqls.add(SqlMapping.get("sweet_city_vote_stat.insert"));
            sqlsDataB.add(new Object[]{
                    IDGenerator.nextSnowId(), aNew.getCityCode(), aNew.getCityName(), 1
            });
        }
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_CITY_VOTE_DRAW.getKey(),
                SqlMapping.gets(sqls, sqlsDataA, sqlsDataB));

        redisDataUtils.incrSweetCityVote(aNew.getCityCode());

        return ResponseDto.success();
    }
}
