package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.param.SweetCityVoteParam;
import com.liquidnet.service.sweet.service.ISweetCityVoteService;
import com.liquidnet.service.sweet.vo.SweetCItyVoteStatVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 城市投票表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-15
 */
@Api(tags = "城市投票")
@RestController
@RequestMapping("/sweetCityVote")
public class SweetCityVoteController {

    @Autowired
    private ISweetCityVoteService sweetCityVoteService;

    @GetMapping("statList")
    @ApiOperation("城市投票排名")
    public ResponseDto<List<SweetCItyVoteStatVo>> getList() {
        return sweetCityVoteService.getList();
    }

    @PostMapping("createVote")
    @ApiOperation("用户投票记录")
    public ResponseDto<Boolean> createVote(@Valid @RequestBody SweetCityVoteParam param) {
        return sweetCityVoteService.createVote(param);
    }

}
