package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 营销秒杀表[活动]
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreMarketPurchasing implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 限时秒杀表id
     */
    private String purchaseId;

    /**
     * 商铺营销表id
     */
    private String storeMarketId;

    /**
     * sku_id
     */
    private String skuId;

    /**
     * 商铺id
     */
    private String storeId;

    /**
     * 活动价格
     */
    private BigDecimal priceMarketing;

    /**
     * 活动库存
     */
    private Integer stockMarketing;

    /**
     * 用户限购[0-不限购|x-限购数量]
     */
    private Integer buyLimit;

    /**
     * 购买条件[0-全部用户|1-仅支持会员|2-指定用户可买]
     */
    private Integer buyType;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private Integer delFlag;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
