package com.liquidnet.service.galaxy.router.xuper.biz;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.third.xuper.config.XuperConfig;
import com.liquidnet.common.third.xuper.dto.*;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.biz.GalaxyBeanTransferBiz;
import com.liquidnet.service.galaxy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBindBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftOrderFailLogVo;
import com.liquidnet.service.galaxy.exception.GalaxyNftPublishException;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import com.liquidnet.service.galaxy.utils.QueueUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XuperTradeBiz
 * @Package com.liquidnet.service.galaxy.router.xuper.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:11
 */
@Slf4j
@Component
public class XuperTradeBiz {
    @Autowired
    private XuperSdkUtil xuperSdkUtil;

    @Autowired
    private XuperConfig xuperConfig;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Autowired
    private GalaxyBeanTransferBiz galaxyBeanTransferBiz;

    @Autowired
    private XuperTradeCommonBiz xuperTradeCommonBiz;

    @Autowired
    private QueueUtil queueUtil;

    @Autowired
    private XuperPublishBiz xuperPublishBiz;
    /**
     * 发行和购买
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        log.info("开始执行nftPublishAndBuy 请求参数:{}",reqDto.toString());
        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());
        if(StringUtil.isNull(userInfoBo)){
            log.error("开始执行nftPublishAndBuy error msg:{}",GalaxyErrorEnum.NFT_BUY_FAIL_USER_NOT_EXIST.getMessage());
            return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_FAIL_USER_NOT_EXIST.getCode(), GalaxyErrorEnum.NFT_BUY_FAIL_USER_NOT_EXIST.getMessage());
        }

        //获取sku信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNull(seriesNftInfoBo)||StringUtil.isEmpty(seriesNftInfoBo.getSeriesId())){
            log.error("开始执行nftPublishAndBuy error msg:{}",GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
        }

        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        //初始化订单数据
        if(nftOrderBo==null){
            nftOrderBo = galaxyBeanTransferBiz.buildNftOrderBo(reqDto.getNftOrderPayId(),userInfoBo,seriesNftInfoBo);
            dataUtils.setNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId(),nftOrderBo);
        }else if(StringUtil.isNotNull(nftOrderBo)){
            if(nftOrderBo.getNftPublishStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())
                    &&nftOrderBo.getNftBuyStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                GalaxyNftPublishAndBuyRespDto nftPublishAndBuyRespDto = GalaxyNftPublishAndBuyRespDto.getNew();
                nftPublishAndBuyRespDto.setUserId(reqDto.getUserId());
                nftPublishAndBuyRespDto.setNftId(nftOrderBo.getNftId());
                log.error("开始执行nftPublishAndBuy error msg:{}", GalaxyErrorEnum.PUBLISH_FAIL_ALREADY_EXIST.toString());
                return ResponseDto.success(nftPublishAndBuyRespDto);
            }
            if(nftOrderBo.getNftPublishStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())
                    &&(nftOrderBo.getNftBuyStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.INIT.getCode())
                    ||nftOrderBo.getNftBuyStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.PROCESSING.getCode()))){
                //再次发起购买
                GalaxyNftPublishAndBuyRespDto nftPublishAndBuyRespDto = xuperTradeCommonBiz.executeBuyBusiness(reqDto,userInfoBo,seriesNftInfoBo,nftOrderBo);
                if(StringUtil.isNotNull(nftPublishAndBuyRespDto)&&StringUtil.isNotEmpty(nftPublishAndBuyRespDto.getNftId())){
                    return ResponseDto.success(nftPublishAndBuyRespDto);
                }else{
                    log.error("开始执行nftPublishAndBuy-->executeBuyBusiness error msg:{}",GalaxyErrorEnum.NFT_BUY_FAIL.getMessage());
                    return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_FAIL.getCode(),GalaxyErrorEnum.NFT_BUY_FAIL.getMessage());
                }
            }
        }

        //开始索引
        Integer seriesBeginIndex = null;
        /**
         * 根据sku获取系列Id
         */
        String seriesId = seriesNftInfoBo.getSeriesId();
        //返回参数nftId
        String nftId = null;
        String publishTaskId = null;
        Long nftPublishChainTimestamp = null;
        Integer nftPublishStatus = null;
        String nftPublishTradeHash = null;

        //定义失败信息
        String failDesc = null;

        try{
            /**
             * 获取订单和nft绑定信息
             */
            GalaxyNftOrderBindBo nftOrderBindBo = dataUtils.getGalaxyNftOrderBindBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
            if(StringUtil.isNull(nftOrderBindBo)){
                //获取发行索引
                long nftIdNo = dataUtils.incrNftIdNo(reqDto.getRouterType(),reqDto.getSkuId());
                //如果发行数大于最大发行数量
                if(nftIdNo > seriesNftInfoBo.getNftTotalCount()){
                    //发行失败
                    throw new GalaxyNftPublishException(GalaxyErrorEnum.NFT_PUBLISH_ERROR.getCode(),"该sku："+reqDto.getSkuId()+" 总共"+seriesNftInfoBo.getNftTotalCount()+"个NFT已经发行完毕，没有剩余库存！");
                }
                nftOrderBindBo = GalaxyNftOrderBindBo.getNew();
                nftOrderBindBo.setNftOrderPayId(reqDto.getNftOrderPayId());
                nftOrderBindBo.setSeriesId(seriesNftInfoBo.getSeriesId());
                nftOrderBindBo.setSeriesCode(seriesNftInfoBo.getSeriesCode());
                nftOrderBindBo.setNftIdIndex(Integer.valueOf(String.valueOf(nftIdNo)));
                nftOrderBindBo.setRouterType(reqDto.getRouterType());
                String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
                nftOrderBindBo.setCreatedAt(nowTimeStr);
                dataUtils.setGalaxyNftOrderBindBo(reqDto.getRouterType(),reqDto.getNftOrderPayId(),nftOrderBindBo);
            }
            seriesBeginIndex = nftOrderBindBo.getNftIdIndex();

            /**
             * 如果已经发行成功
             */
            if(nftOrderBo.getNftPublishStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.PROCESSING.getCode())){
                if(StringUtil.isNotEmpty(nftOrderBo.getNftPublishTaskId())){
                    publishTaskId = nftOrderBo.getNftPublishTaskId();
                }
            }else if(nftOrderBo.getNftPublishStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.INIT.getCode())){
                //发行
                Xuper004PublishAssetReqDto xuper004PublishAssetReqDto = Xuper004PublishAssetReqDto.getNew();
                // 定义返回结果对象
                Xuper004PublishAssetRespDto xuper004PublishAssetRespDto = null;
                long assetId = Long.parseLong(seriesNftInfoBo.getSeriesId());
                try {
                    xuper004PublishAssetReqDto.setMnemonic(xuperConfig.getNftPlatformMnemonic());
                    xuper004PublishAssetReqDto.setAssetId(assetId);
                    XuperResponseDto<Xuper004PublishAssetRespDto> xuperResponseDto = xuperSdkUtil.xuper004PublishAsset(xuper004PublishAssetReqDto);
                    if(xuperResponseDto.isSuccess()){
                        xuper004PublishAssetRespDto = xuperResponseDto.getParseData(Xuper004PublishAssetRespDto.class);
                    }
                }catch (XupterException e) {
                    log.error("biz error msg "+e.getMessage(),e);
                }catch (Exception e) {
                    log.error("sys error msg "+e.getMessage(),e);
                }
                log.info("xuper004PublishAsset resp : "+ JsonUtils.toJson(xuper004PublishAssetRespDto));

                if (Integer.parseInt(ErrorCode.SUCCESS.getCode()) == xuper004PublishAssetRespDto.errNo){
                    publishTaskId = String.valueOf(assetId);
                    nftOrderBo.setNftPublishTaskId(publishTaskId);
                }
            }

            if (StringUtil.isNotEmpty(publishTaskId)){
                try{
                    nftPublishChainTimestamp = DateUtil.getNowSeconds();
                    nftPublishStatus = Integer.parseInt(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode());
                    nftPublishTradeHash = publishTaskId;

                    //赋值返回参数
                    nftId = seriesId.concat("_").concat(seriesBeginIndex.toString());
                    nftOrderBo.setNftId(nftId);
                    log.info("发行NFT后返回给前端nftID:{}", nftId);
                }catch (GalaxyNftPublishException e){
                    throw new GalaxyNftPublishException(e.getCode(),e.getMessage());
                }catch(Exception e){
                    log.error(e.getMessage(),e);
                    //发行失败
                    throw new GalaxyNftPublishException(GalaxyErrorEnum.NFT_PUBLISH_ERROR.getCode(),"nft035PublishResult_exception:"+e.getMessage());
                }
            }else{
                //发行失败
                throw new GalaxyNftPublishException(GalaxyErrorEnum.NFT_PUBLISH_ERROR.getCode(),"nft034Publish_resp:taskId : "+publishTaskId);
            }
        }catch (GalaxyNftPublishException e) {
            failDesc = e.getMessage();
        }catch(Exception e){
            failDesc = e.getMessage();
            log.error(e.getMessage(),e);

        }

        if(StringUtil.isNotEmpty(failDesc)){
            //记录发行异常信息
            try{
                //发行异常或者失败记录任务id
                if(StringUtil.isNotNull(nftOrderBo)&&StringUtil.isNotEmpty(nftOrderBo.getNftPublishTaskId())){
                    nftOrderBo.setNftPublishStatus(GalaxyEnum.TaskStatusEnum.PROCESSING.getCode());
                    nftOrderBo.setUpdatedAt(LocalDateTime.now());
                    //更新nft发行状态为处理中
                    dataUtils.updateNftOrderPublishInfo(reqDto.getRouterType(),reqDto.getNftOrderPayId(),nftOrderBo);
                }else{
                    //记录错误信息
                    GalaxyNftOrderFailLogVo nftOrderFailLogVo = galaxyBeanTransferBiz.buildNftOrderFailLogVo(GalaxyEnum.TradeTypeEnum.TRADE_PUBLISH,reqDto,GalaxyEnum.OrderDealWithStatusEnum.DATA_INIT,failDesc,null
                            ,userInfoBo,seriesNftInfoBo,nftOrderBo);
                    dataUtils.setNftOrderFailLogVo(reqDto.getRouterType(),nftOrderFailLogVo);
                }
            }catch(Exception e){
                log.error(reqDto.getNftOrderPayId()+"发行setNftOrderFailLogVo记录异常："+e.getMessage(),e);
            }
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_FAIL.getCode(), GalaxyErrorEnum.PUBLISH_FAIL.getMessage());
        }

        //更新订单缓存数据状态
        if(StringUtil.isNotEmpty(nftOrderBo.getNftId())){
            if(StringUtil.isNotNull(nftPublishChainTimestamp)){
                //设置时间
                String nftPublishChainTimestampStr = DateUtil.format(new Date(nftPublishChainTimestamp*1000),DateUtil.Formatter.yyyyMMddHHmmss);
                nftOrderBo.setNftPublishChainTimestamp(nftPublishChainTimestampStr);
            }
            if(StringUtil.isNotNull(nftPublishStatus)){
                //转换任务状态
                String nftPublishStatusStr = GalaxyEnumBiz.getTaskStatusEnum(reqDto.getRouterType(),nftPublishStatus.toString()).getCode();
                nftOrderBo.setNftPublishStatus(nftPublishStatusStr);
            }
            nftOrderBo.setNftPublishTradeHash(nftPublishTradeHash);
            nftOrderBo.setUpdatedAt(LocalDateTime.now());
            //先更新nft发行数据
            dataUtils.updateNftOrderPublishInfo(reqDto.getRouterType(),reqDto.getNftOrderPayId(),nftOrderBo);
        }

        //第二步：执行购买逻辑
        if(StringUtil.isNotEmpty(nftOrderBo.getNftId())){
            GalaxyNftPublishAndBuyRespDto nftPublishAndBuyRespDto = xuperTradeCommonBiz.executeBuyBusiness(reqDto,userInfoBo,seriesNftInfoBo,nftOrderBo);
            if(StringUtil.isNotNull(nftPublishAndBuyRespDto)&&StringUtil.isNotEmpty(nftPublishAndBuyRespDto.getNftId())){
                return ResponseDto.success(nftPublishAndBuyRespDto);
            }else{
                return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_FAIL.getCode(),GalaxyErrorEnum.NFT_BUY_FAIL.getMessage());
            }
        }
        return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_FAIL.getCode(), GalaxyErrorEnum.PUBLISH_FAIL.getMessage());
    }


    /**
     * NFT发行和购买
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishAndBuyResultQueryRespDto> nftPublishAndBuyResultQuery(GalaxyNftPublishAndBuyResultQueryReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getMessage());
        }

        /**
         * TODO 如果订单信息是购买失败，则直接调用至信链查询购买结果
         */
        //是否需要发起二次购买
        boolean isNeedSecondBuy = false;
        if(StringUtil.isNotEmpty(nftOrderBo.getNftPublishStatus())
                && (GalaxyEnum.TaskStatusEnum.INIT.getCode().equalsIgnoreCase(nftOrderBo.getNftPublishStatus())
                ||GalaxyEnum.TaskStatusEnum.PROCESSING.getCode().equalsIgnoreCase(nftOrderBo.getNftPublishStatus()))){
            //判断是否需要二次购买
            if(StringUtil.isEmpty(nftOrderBo.getNftPublishTaskId())){
                isNeedSecondBuy = true;
            }
            //执行nft发行结果查询
            GalaxyNftPublishResultQueryReqDto nftPublishResultQueryReqDto = GalaxyNftPublishResultQueryReqDto.getNew();
            nftPublishResultQueryReqDto.setNftOrderPayId(reqDto.getNftOrderPayId());
            nftPublishResultQueryReqDto.setRouterType(reqDto.getRouterType());
            ResponseDto<GalaxyNftPublishResultQueryRespDto> publishResultQueryRespDto = xuperPublishBiz.nftPublishResultQuery(nftPublishResultQueryReqDto);
            if(publishResultQueryRespDto.isSuccess()){
                GalaxyNftPublishResultQueryRespDto nftPublishResultQueryRespDtoTemp = publishResultQueryRespDto.getData();
                BeanUtil.copy(nftPublishResultQueryRespDtoTemp,nftOrderBo);
            }
        }else if(StringUtil.isNotEmpty(nftOrderBo.getNftBuyStatus())
                && (GalaxyEnum.TaskStatusEnum.INIT.getCode().equalsIgnoreCase(nftOrderBo.getNftBuyStatus())
                ||GalaxyEnum.TaskStatusEnum.PROCESSING.getCode().equalsIgnoreCase(nftOrderBo.getNftBuyStatus()))){
            //判断是否需要二次购买
            if(StringUtil.isEmpty(nftOrderBo.getNftBuyTaskId())){
                isNeedSecondBuy = true;
            }
            //执行nft购买结果查询
            GalaxyNftBuyResultQueryReqDto nftBuyResultQueryReqDto = GalaxyNftBuyResultQueryReqDto.getNew();
            nftBuyResultQueryReqDto.setNftOrderPayId(reqDto.getNftOrderPayId());
            nftBuyResultQueryReqDto.setRouterType(reqDto.getRouterType());
            ResponseDto<GalaxyNftBuyResultQueryRespDto> buyResultQueryRespDto= xuperTradeCommonBiz.nftBuyResultQuery(nftBuyResultQueryReqDto);
            if(buyResultQueryRespDto.isSuccess()){
                GalaxyNftBuyResultQueryRespDto nftBuyResultQueryRespDtoTemp = buyResultQueryRespDto.getData();
                BeanUtil.copy(nftBuyResultQueryRespDtoTemp,nftOrderBo);
            }
        }

        //判断是否需要二次购买
//        if(isNeedSecondBuy){
//            GalaxyNftPublishAndBuyReqDto galaxyNftPublishAndBuyReqDto = GalaxyNftPublishAndBuyReqDto.getNew();
//            BeanUtil.copy(reqDto,galaxyNftPublishAndBuyReqDto);
//            galaxyNftPublishAndBuyReqDto.setSkuId(nftOrderBo.getSkuId());
//            galaxyNftPublishAndBuyReqDto.setBuyTimestamp(DateUtil.getNowTime());
//            queueUtil.sendMsgByRedis(MQConst.GalaxyQueue.JSON_NFT_PUBLISH_AND_BUY.getKey(), JsonUtils.toJson(galaxyNftPublishAndBuyReqDto));
//        }

        GalaxyNftPublishAndBuyResultQueryRespDto resultQueryRespDto = GalaxyNftPublishAndBuyResultQueryRespDto.getNew();
        if(nftOrderBo.getNftPublishStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())&&
                nftOrderBo.getNftBuyStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
            BeanUtil.copy(nftOrderBo,resultQueryRespDto);
            return ResponseDto.success(resultQueryRespDto);
        }
        return ResponseDto.failure(GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getCode(),GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getMessage(),resultQueryRespDto);
    }
}
