package com.liquidnet.service.galaxy.router.xuper.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserBindStatusQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserBindStatusQueryRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterRespDto;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyUser;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterUserHandler;
import com.liquidnet.service.galaxy.router.xuper.biz.XuperUserBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyXuperUserImpl
 * @Package com.liquidnet.service.galaxy.router.xuper.service
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:05
 */
@Slf4j
@Component
@StrategyGalaxyRouterUserHandler(GalaxyEnum.RouterTypeEnum.XUPER)
public class GalaxyRouterStrategyXuperUserImpl implements IGalaxyRouterStrategyUser {
    @Autowired
    private XuperUserBiz xuperUserBiz;

    @Override
    public ResponseDto<GalaxyUserRegisterRespDto> userRegister(GalaxyUserRegisterReqDto reqDto) {
        return xuperUserBiz.userRegister(reqDto);
    }

    @Override
    public ResponseDto<GalaxyUserBindStatusQueryRespDto> userBindStatusQuery(GalaxyUserBindStatusQueryReqDto reqDto) {
        return xuperUserBiz.userBindStatusQuery(reqDto);
    }
}

