package com.liquidnet.service.goblin.test.xuper;

import com.baidu.xasset.auth.Crypto;
import com.baidu.xasset.client.base.Base;
import com.baidu.xuper.api.Account;
import com.liquidnet.common.third.xuper.config.XuperConfig;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.galaxy.biz.GalaxyCommonBiz;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.io.File;
import java.io.IOException;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestUrlHash
 * @Package com.liquidnet.service.goblin.test.xuper
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/29 16:10
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestUrlHash {
    @Autowired
    private GalaxyCommonBiz galaxyCommonBiz;

    @Autowired
    private XuperSdkUtil xuperSdkUtil;

    @Autowired
    private XuperConfig xuperConfig;


    @Test
    public void testGetNftHashByNftUrl(){
        String url = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
        log.info("hash === {} ",this.getNftHashByNftUrl(url));
    }

    private String getNftHashByNftUrl(String originalUrl){
        //原始介质文件hash值
        String nftHashStr = null;
        try {
            String filePath = null;
            String imageType = null;

            if(originalUrl.lastIndexOf("?")!=-1){
                String tempUrl = originalUrl.substring(0,originalUrl.lastIndexOf("?"));
                imageType = tempUrl.substring(tempUrl.lastIndexOf("."),tempUrl.length());
            }else{
                imageType = originalUrl.substring(originalUrl.lastIndexOf("."),originalUrl.length());
            }
            String fileName =  IDGenerator.getXuperNftImageCosCode() + imageType;

            //通过图片url地址上传
            File cosFile = galaxyCommonBiz.inputStreamToFile(originalUrl,fileName);
            filePath = cosFile.getPath();
            log.info("cosFile.getPath() :{}",cosFile.getPath());//Users/anjiabin/data/galaxy/tempFilePath/XUPERNFTIMAGE202206291056041871343690.jpg
            log.info("cosFile.getAbsoluteFile() :{}",cosFile.getAbsoluteFile());///Users/anjiabin/mdsky_gitlab/liquidnet-bus-v1/Users/anjiabin/data/galaxy/tempFilePath/XUPERNFTIMAGE202206291056041871343690.jpg

            byte[] fileByte = new byte[0];
            try {
                fileByte = galaxyCommonBiz.toByteArray(new File(filePath));
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Account account = xuperSdkUtil.getAccount(xuperConfig.getNftPlatformMnemonic());
                nftHashStr = Crypto.xassetSignECDSA(account,fileByte);
            } catch (Exception var25) {
                Base.logger.warning("account esdsa sign failed" + var25);
                throw new XupterException(GalaxyErrorEnum.SERIES_NFT_HASH_CREATE_FAIL.getCode(),GalaxyErrorEnum.SERIES_NFT_HASH_CREATE_FAIL.getMessage());
            }

//            nftHashStr = new String(Hash.doubleSha256(fileByte));
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }

        log.info("getNftHashByNftUrl url：{} ,hashStr:{}",originalUrl,nftHashStr);
        return  nftHashStr;
    }
}
