package com.liquidnet.service.kylin.utils;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

@Component
@Slf4j
public class GoblinOrderUtils {

    @Value("${liquidnet.service.candy.url}")
    private String candyUrl;
  /*  @Autowired
    GoblinRedisUtils redisUtils;*/
    private KylinRedisUtils kylinRedisUtils;
    @Autowired
    QueueUtils queueUtils;


    // NFT判断是否售罄
    public HashMap<String, Integer> getIsStock(String listId, String skuId, String unbox, String soldoutStatus, List<String> skuIdList) {
        HashMap<String, Integer> returnMap = CollectionUtil.mapStringInteger();
        Integer isStock = 0;
        Integer totalStock = 0;
        if (null == soldoutStatus || soldoutStatus.equals("0")) {// 未设置售罄 查询库存
            int surplusStock = 0;
            if (unbox.equals("0")) {// 不是盲盒
                surplusStock = kylinRedisUtils.getSkuStock(listId, skuId);
            } else {
                for (String skuIdItem : skuIdList) {// 盲盒计算所有sku库存总数
                    if (skuIdItem.equals(skuId)) {// 过滤自己
                        continue;
                    }
                    HashMap<String, Object> map = kylinRedisUtils.getGoodsSkuInfoVo(LocalDateTime.now(), skuIdItem);
                    GoblinGoodsSkuInfoVo itemVo = (GoblinGoodsSkuInfoVo) map.get("vo");
//                    String listId2 = (String) map.get("listId");
//                    surplusStock += redisUtils.getSkuAllStatusStock(itemVo, listId2);
                    surplusStock += kylinRedisUtils.getSkuAllStatusStock(itemVo, listId);
                    totalStock += kylinRedisUtils.getSkuTotalStock(itemVo);
                }
            }
            if (surplusStock > 0) {
                isStock = 1;
            }
        }
        returnMap.put("isStock", isStock);
        returnMap.put("totalStock", totalStock);
        return returnMap;
    }

}
