/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455;

import com.taobao.api.internal.toplink.embedded.websocket.frame.FrameHeader;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.FrameBuilderRfc6455;
import java.nio.ByteBuffer;

public class FrameHeaderRfc6455
implements FrameHeader {
    protected final long payloadLength;
    protected final FrameBuilderRfc6455.PayloadLengthType payloadLengthType;
    protected final int headerLength;
    protected final boolean fragmented;
    protected final FrameBuilderRfc6455.Opcode opcode;
    protected FrameBuilderRfc6455.Opcode realOpcode;
    protected boolean mask;

    public FrameHeaderRfc6455(boolean fragmented, int headerLength, FrameBuilderRfc6455.PayloadLengthType payloadLengthType, long payloadLength, FrameBuilderRfc6455.Opcode opcode) {
        this.headerLength = headerLength + payloadLengthType.offset();
        this.payloadLengthType = payloadLengthType;
        this.payloadLength = payloadLength;
        this.fragmented = fragmented;
        this.opcode = opcode;
    }

    public FrameHeaderRfc6455(boolean fragmented, int headerLength, FrameBuilderRfc6455.PayloadLengthType payloadLengthType, long payloadLength, FrameBuilderRfc6455.Opcode opcode, FrameBuilderRfc6455.Opcode realOpcode) {
        this.headerLength = headerLength + payloadLengthType.offset();
        this.payloadLengthType = payloadLengthType;
        this.payloadLength = payloadLength;
        this.fragmented = fragmented;
        this.opcode = opcode;
        this.realOpcode = realOpcode;
    }

    public long getFrameLength() {
        return (long)this.headerLength + this.payloadLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public long getContentsLength() {
        return this.payloadLength;
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    public boolean isContinuation() {
        return FrameBuilderRfc6455.Opcode.CONTINUATION.equals((Object)this.opcode);
    }

    public FrameBuilderRfc6455.Opcode getOpcode() {
        return this.opcode;
    }

    public FrameBuilderRfc6455.Opcode getRealOpcode() {
        return this.realOpcode;
    }

    public void setMask(boolean mask) {
        this.mask = mask;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(2 + this.payloadLengthType.offset());
        buf.put((byte)((this.fragmented ? 0 : 128) | this.opcode.intValue()));
        byte maskBit = (byte)(this.mask ? 128 : 0);
        switch (this.payloadLengthType) {
            case LEN_SHORT: {
                buf.put((byte)(this.payloadLength | (long)maskBit));
                break;
            }
            case LEN_16: {
                buf.put((byte)(this.payloadLengthType.byteValue() | maskBit));
                buf.putShort((short)this.payloadLength);
                break;
            }
            case LEN_63: {
                buf.put((byte)(this.payloadLengthType.byteValue() | maskBit));
                buf.putLong(this.payloadLength);
            }
        }
        buf.flip();
        return buf;
    }
}

