/**
 * $Id: RandomUtils.java 6145 2016-04-21 05:29:39Z anjiabin $
 * Copyright(C) 2014-2020 easegame, All Rights Reserved.
 */
package com.liquidnet.commons.lang.util;

import java.security.SecureRandom;
import java.util.stream.IntStream;

/**
 * <p>RandomUtils class.</p>
 *
 * @author <a href="mailto:cafebabe.hu@gmail.com">Xiaowei Hu</a>
 * @version 1.0 2016年03月21日 5:54 PM:00
 */
public class RandomUtils {
    /**
     * 生成随机4位数字
     *
     * @return a int.
     */
    public static int secureRandomNumber4() {
        SecureRandom sr = new SecureRandom();
        return sr.nextInt(900_0) + 100_0;
    }

    /**
     * 生成随机6位数字
     *
     * @return a int.
     */
    public static int secureRandomNumber6() {
        SecureRandom sr = new SecureRandom();
        return sr.nextInt(900_000) + 100_000;
    }

    /**
     * <p>main.</p>
     *
     * @param args an array of {@link String} objects.
     */
    public static void main(String [] args) {
        IntStream.range(1, 1000).forEach(i -> System.out.println(secureRandomNumber4()));
    }
}
