package com.liquidnet.service.executor.main.handler;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.platform.task.FeignPlatformGoblinTaskClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * platform:goblin
 */
@Component
public class PlatformGoblinTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(PlatformGoblinTaskHandler.class);
    @Autowired
    private FeignPlatformGoblinTaskClient feignPlatformGoblinTaskClient;

    // 商城:商品预约上架
    @XxlJob(value = "sev-platform:goblinGoodsOnShelvesHandler")
    public ReturnT<String> goblinGoodsOnShelvesHandler() {
        try {
            ResponseDto<String> dto = feignPlatformGoblinTaskClient.goodsOnShelvesHandler();
            String dtoStr = JsonUtils.toJson(dto);
            log.info("result of handler:{}", dtoStr);
            ReturnT<String> success = ReturnT.SUCCESS;
            success.setMsg(dtoStr);
            return success;
        } catch (Exception e) {
            log.error("exception of handler:{}", e.getMessage(), e);
            ReturnT<String> fail = ReturnT.FAIL;
            fail.setMsg(e.getLocalizedMessage());
            return fail;
        }
    }
}
