package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileAgentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Api(tags = "代理配置")
@RestController
@RequestMapping("/smile/agent")
public class SmileAgentController {

    @Autowired
    ISmileAgentService smileAgentService;

    @GetMapping("/list")
    @ApiOperation("获取票提")
    @ResponseBody
    public AjaxResult organizationList(String performanceId, String ticketId){
        return AjaxResult.success(smileAgentService.listAgentByShowIdAndTicketId(performanceId,ticketId));
    }


}
