package com.liquidnet.service.account.wallet.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * WalletDashboardInfoVo.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/10
 */
@ApiModel(value = "WalletDashboardInfoVo", description = "Details of wallet dashboard")
public class WalletDashboardInfoVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 5087728198069789344L;
    @ApiModelProperty(position = 11, required = true, value = "Unit data identification [Follow unit changes]")
    private String unitId;
    @ApiModelProperty(position = 12,value = "Period unit [H,D...]")
    private String unit;
    @ApiModelProperty(position = 13,value = "Chart name")
    private String chart;
    @ApiModelProperty(position = 21, value = "Wallet Balance: Available Balance")
    private BigDecimal availableBalance;
    @ApiModelProperty(position = 22, value = "Wallet Balance: Pending Balance")
    private BigDecimal pendingBalance;

    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getChart() {
        return chart;
    }

    public void setChart(String chart) {
        this.chart = chart;
    }

    public BigDecimal getAvailableBalance() {
        return availableBalance;
    }

    public void setAvailableBalance(BigDecimal availableBalance) {
        this.availableBalance = availableBalance;
    }

    public BigDecimal getPendingBalance() {
        return pendingBalance;
    }

    public void setPendingBalance(BigDecimal pendingBalance) {
        this.pendingBalance = pendingBalance;
    }

    private static final WalletDashboardInfoVo obj = new WalletDashboardInfoVo();

    public static WalletDashboardInfoVo getNew() {
        try {
            return (WalletDashboardInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new WalletDashboardInfoVo();
    }
}
