package com.liquidnet.service.adam.controller;


import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamMemberOrderCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderParam;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import com.liquidnet.service.adam.service.IAdamMemberOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "购买会员")
@Slf4j
@RestController
@RequestMapping("/member/order")
public class AdamMemberOrderController {

    @Autowired
    IAdamMemberOrderService adamMemberOrderService;

    @ApiOperationSupport(order = 0)
    @ApiOperation(value = "购买会员或兑换码")
    @PostMapping("/buy/member")
    public ResponseDto<AdamMemberOrder> buyMemberOrCode(AdamMemberOrderParam param) {
        try {
            adamMemberOrderService.buyMemberOrMemberCode(param);
            return new ResponseDto().success();
        } catch (Exception e) {
            e.printStackTrace();
            return new ResponseDto().failure();
        }
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "使用兑换码")
    @PostMapping("/use/memberCode")
    public ResponseDto<AdamMemberOrder> useMemberCode(AdamMemberOrderCodeParam param) {
        try {
            adamMemberOrderService.useMemberCode(param);
            return new ResponseDto().success();
        } catch (Exception e) {
            e.printStackTrace();
            return new ResponseDto().failure();
        }
    }

}
