package com.liquidnet.service.kylin.service.partner;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.kylin.dto.param.CreateTicketTimesParam;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesPartnerVo;
import com.liquidnet.service.kylin.entity.KylinTicketTimes;

import java.util.List;

/**
 * <p>
 * 场次 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
public interface IKylinTicketTimesPartnerService extends IService<KylinTicketTimes> {


    /**
     * 创建场次汇总
     * @param createTicketTimesParam 相关参数
     * @return vo
     */
    TicketTimesPartnerVo createTimesSummary(CreateTicketTimesParam createTicketTimesParam);

    /**
     * 未通过审核创建场次
     * @param createTicketTimesParam 相关参数
     * @return vo
     */
    TicketTimesPartnerVo createTimes(CreateTicketTimesParam createTicketTimesParam);

    /**
     * 通过审核后创建场次
     * @param createTicketTimesParam 相关参数
     * @return 相关参数
     */
    TicketTimesPartnerVo addNewTimes(CreateTicketTimesParam createTicketTimesParam);

    /**
     * 删除 场次(只有未审核通过可删除)
     * @param ticketTimesId 场次id
     * @return boolean
     */
    Boolean deleteTimes(String ticketTimesId);

    /**
     * 修改场次信息
     * @param createTicketTimesParam 相关参数
     * @return vo
     */
    TicketTimesPartnerVo changeTimes(CreateTicketTimesParam createTicketTimesParam);

    /**
     * 根据演出id 获取全部场次数据
     * @param performancesId 演出id
     * @return list<vo>
     */
    List<TicketTimesPartnerVo> getTimesMongoList(String performancesId);

    /**
     * 根据场次id 获取场次信息
     * @param timesId 场次id
     * @return vo
     */
    TicketTimesPartnerVo getTimesMongo(String timesId);
}
