package com.liquidnet.service.goblin.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinShoppingCartVoo;
import com.liquidnet.service.goblin.service.impl.GoblinFrontServiceImpl;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhangfuxin
 * @Description:前端接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端需要登陆接口管理")
@RestController
@RequestMapping("/frontLogin")
public class GoblinFrontLoginController    {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinFrontServiceImpl goblinFrontService;

    @GetMapping("addShopCart")
    @ApiOperation("加入购物车")
    public ResponseDto addShopCart(@RequestParam(name = "spuId", required = true) String spuId,@RequestParam(name = "storeId", required = true) String storeId,@RequestParam(name = "skuId", required = true) String skuId,@RequestParam(name = "number", required = false) Integer number,@RequestParam(name = "type", required = true) String type) {
        String userId=CurrentUtil.getCurrentUid();
        return ResponseDto.success( goblinFrontService.addShoopCart(spuId,storeId,skuId,number,userId,type));
    }
    @GetMapping("updateShopCart")
    @ApiOperation("修改购物车")
    public ResponseDto updateShopCart(@RequestParam(name = "spuId", required = true) String spuId,@RequestParam(name = "storeId", required = true) String storeId,@RequestParam(name = "skuId", required = true) String skuId,@RequestParam(name = "number", required = false) Integer number,@RequestParam(name = "type", required = true) String type) {
        String userId=CurrentUtil.getCurrentUid();
        return ResponseDto.success( goblinFrontService.updateShopCart(spuId,storeId,skuId,number,userId,type));
    }


    @GetMapping("getShopCartCount")
    @ApiOperation("获取购物车数量")
    public ResponseDto getShopCartCount(@RequestParam(name = "type", required = true)String type) {
        String userId=CurrentUtil.getCurrentUid();
        return ResponseDto.success(goblinFrontService.getShopCartCount(userId,type));
    }
    @PostMapping("deleteShopCart")
    @ApiOperation("删除购物车")
    public ResponseDto deleteShopCart(@RequestParam(name = "skuIds", required = false) String skuIds,@RequestParam(name = "type", required = true) String type) {
        String userId=CurrentUtil.getCurrentUid();
        return ResponseDto.success(goblinFrontService.delteShoppingCart(skuIds.split(","),userId,type));
    }
    @PostMapping("saveData")
    @ApiOperation("保存数据购物车过度")
    public ResponseDto saveData(@RequestParam(name = "data", required = false)String data,@RequestParam(name = "type", required = true)String type) {
        String userId=CurrentUtil.getCurrentUid();
        return ResponseDto.success(goblinFrontService.saveDate(data,userId,type));
    }
    @PostMapping("getData")
    @ApiOperation("获得购物车过度")
    public ResponseDto getData(@RequestParam(name = "type", required = true)String type) {
        String userId=CurrentUtil.getCurrentUid();
        return ResponseDto.success(goblinFrontService.getDate(userId,type));
    }


    @GetMapping("getShopCart")
    @ApiOperation("获得购物车列表")
    public ResponseDto<GoblinShoppingCartVoo> getShopCart(@RequestParam(name = "type", required = true)String type) {
        String userId=CurrentUtil.getCurrentUid();
        return ResponseDto.success(goblinFrontService.getShoppCart(userId,type));
    }










}
