package com.liquidnet.service.bank.currencycloud.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(description = "payment param")
public class BankCcPaymentParam {



    @ApiModelProperty(value = "绑定银行卡信息id")
    private String beneficiaryId;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty(value = "在途换汇交易id")
    private String conversionId;

    @ApiModelProperty(value = "金额", required = true)
    private BigDecimal amount;

    @ApiModelProperty(value = "币种", required = true)
    private String currency;

    @ApiModelProperty(value = "交易类型 priority/regular")
    private String paymentType;

    @ApiModelProperty(value = "reference", required = true)
    private String reference;

    private String shortReference;

    @ApiModelProperty(value = "reason", required = true)
    private String reason;

    @ApiModelProperty(value = "下发日期  ISO 8601 format, yyyy-MM-dd")
    private Date paymentDate;

    @ApiModelProperty(value = "Contact UUID.", required = true)
    private String creatorContactId;

    @ApiModelProperty(value = "User-generated idempotency key.")
    private String uniqueRequestId;

    @ApiModelProperty(value = "The name of the ultimate beneficiary if different.")
    private String ultimateBeneficiaryName;

    @ApiModelProperty(value = "Payment Purpose Code (Mandatory for all INR payments).")
    private String purposeCode;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @ApiModelProperty(value = "ours/shared")
    private String chargeType;

    @ApiModelProperty(value = "Fee amount.")
    private BigDecimal feeAmount;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @ApiModelProperty(value = "Currency fee is paid in.")
    private String feeCurrency;

    @ApiModelProperty("payerId 使用临时payer时可为空")
    private String payerId;

}
