package com.liquidnet.service.platform.controller.data;


import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.entity.KylinTicketRelations;
import com.liquidnet.service.kylin.entity.KylinTicketStatus;
import com.liquidnet.service.kylin.mapper.KylinTicketRelationsMapper;
import com.liquidnet.service.kylin.mapper.KylinTicketStatusMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-11
 */
@Api(tags = "临时数据处理")
@RestController
@RequestMapping("performance-data")
@Slf4j
public class JxlDataController {

    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;
    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;
    @Autowired
    private MongoTemplate mongoTemplate;

    @GetMapping("fskfsfs")
    @ApiOperation("dfsfsfs")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performancesId", value = "演出id", required = true),
    })
    public ResponseDto sfsfs(
            @RequestParam("performancesId") String performancesId
    ) {
        LocalDateTime createdAt = LocalDateTime.now();

        List<KylinTicketTimesPartnerVo> voTimes = mongoTemplate.find(Query.query(Criteria.where("performancesId").is(performancesId)),
                KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
        Integer num = 1;
        for (KylinTicketTimesPartnerVo voTime : voTimes) {
            List<KylinTicketPartnerVo> timesIdVo = mongoTemplate.find(Query.query(
                            Criteria.where("timesId").is(voTime.getTicketTimesId())),
                    KylinTicketPartnerVo.class,
                    KylinTicketPartnerVo.class.getSimpleName());
            for (KylinTicketPartnerVo ticketVo : timesIdVo) {
                LocalDateTime timeC = null;
                LocalDateTime timeU = null;
                try {
                    timeC = DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketVo.getCreatedAt()));
                } catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    timeU = DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketVo.getUpdatedAt()));
                } catch (Exception e) {
                    e.printStackTrace();
                }

                String ticketsId = ticketVo.getTicketsId();
                KylinTicketRelations ticketRelations = new KylinTicketRelations();
                BeanUtils.copyProperties(ticketVo, ticketRelations);
                ticketRelations.setCreatedAt(timeC);
                ticketRelations.setUpdatedAt(timeU);
                ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId());
                ticketRelations.setTicketId(ticketsId);
                // 场次与票种关联表
                ticketRelationsMapper.insert(ticketRelations);

                KylinTicketStatus ticketStatusNew = new KylinTicketStatus();
                BeanUtils.copyProperties(ticketVo, ticketStatusNew);
                ticketStatusNew.setTicketId(ticketsId);
                ticketStatusNew.setStatusExchange(7);
                if(ticketVo.getExpressType()==null){
                    ticketStatusNew.setExpressType(0);
                }
                PerformancePartnerVo performanceData = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
                ticketStatusNew.setIsTrueName(performanceData.getIsTrueName());
                ticketStatusNew.setMemberLimitCount(1);
                ticketStatusNew.setCreatedAt(timeC);
                ticketStatusNew.setUpdatedAt(timeU);
                if (ticketVo.getIsShowCode() == 1) {
                    try {
                        ticketStatusNew.setQrCodeShowTime(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketVo.getQrCodeShowTime())));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                KylinTicketStatus ticketStatus = ticketStatusMapper.selectOne(
                        Wrappers.lambdaQuery(KylinTicketStatus.class)
                                .eq(KylinTicketStatus::getTicketId, ticketsId)
                );
                if (null == ticketStatus) {// 添加
                    ticketStatusNew.setTicketStatusId(IDGenerator.nextSnowId());
                    ticketStatusMapper.insert(ticketStatusNew);
                    System.out.println("新增---------------------------------");
                    System.out.println(ticketsId);
                    System.out.println(ticketStatusNew);
                } else {// 编辑
                    ticketStatusMapper.update(ticketStatusNew,
                            new UpdateWrapper<KylinTicketStatus>().
                                    eq("ticket_id", ticketsId)
                    );
                    System.out.println("编辑---------------------------------");
                    System.out.println(ticketsId);
                    System.out.println(ticketStatusNew);
                }
            }
        }

//        dataUtils.delPerformanceRedis(performancesId);
//        System.out.println(voTimes);
        return ResponseDto.success();
    }

}
