package com.liquidnet.client.admin.zhengzai.sweet.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityFromParam;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityListSearchParam;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityPrizeFormParam;
import com.liquidnet.service.sweet.dto.vo.admin.SweetIntegralActivityPrizeVo;
import com.liquidnet.service.sweet.dto.vo.admin.SweetIntegralActivityVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityDraw;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrize;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityDrawMapper;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityPrizeMapper;
import com.liquidnet.service.sweet.utils.SweetNewObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 积分活动表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Service
public class SweetIntegralActivityServiceImpl extends ServiceImpl<SweetIntegralActivityMapper, SweetIntegralActivity> implements ISweetIntegralActivityService {

    @Autowired
    SweetIntegralActivityMapper sweetIntegralActivityMapper;
    @Autowired
    SweetIntegralActivityPrizeMapper sweetIntegralActivityPrizeMapper;
    @Autowired
    SweetIntegralActivityDrawMapper sweetIntegralActivityDrawMapper;

    @Override
    public PageInfo<SweetIntegralActivity> list(SweetIntegralActivityListSearchParam listParam) {
        PageHelper.startPage(listParam.getPageNum(), listParam.getPageSize());
        LambdaQueryWrapper<SweetIntegralActivity> lambdaQueryWrapper = Wrappers.lambdaQuery(SweetIntegralActivity.class);
        if (!listParam.getActivityTitle().isEmpty()) {
            lambdaQueryWrapper.like(SweetIntegralActivity::getActivityTitle, listParam.getActivityTitle());
        }
        List<SweetIntegralActivity> sweetIntegralActivities = sweetIntegralActivityMapper.selectList(lambdaQueryWrapper);
        // TODO: 2021/10/20 查询奖品数量 中奖数量计算展示 返回vo
        return new PageInfo(sweetIntegralActivities);
    }

    @Override
    public Integer isOnline(String integralActivityId, Integer isOnline) {
        SweetIntegralActivity aNew = SweetIntegralActivity.getNew();
        aNew.setIsOnline(isOnline);
        int result = sweetIntegralActivityMapper.update(
                aNew,
                Wrappers.lambdaUpdate(SweetIntegralActivity.class).eq(SweetIntegralActivity::getIntegralActivityId, integralActivityId)
        );
        // TODO: 2021/10/20 更新缓存
        return result;
    }

    @Override
    public SweetIntegralActivityVo detail(String integralActivityId) {
        SweetIntegralActivity sweetIntegralActivity = sweetIntegralActivityMapper.selectOne(
                Wrappers.lambdaQuery(SweetIntegralActivity.class).eq(SweetIntegralActivity::getIntegralActivityId, integralActivityId)
        );
        SweetIntegralActivityVo integralActivityVo = SweetIntegralActivityVo.getNew().copy(sweetIntegralActivity);
        List<SweetIntegralActivityPrize> sweetIntegralActivityPrizes = sweetIntegralActivityPrizeMapper.selectList(
                Wrappers.lambdaQuery(SweetIntegralActivityPrize.class).eq(SweetIntegralActivityPrize::getIntegralActivityId, integralActivityId)
        );
        if (!CollectionUtils.isEmpty(sweetIntegralActivityPrizes)) {
            List<SweetIntegralActivityPrizeVo> prizeVoList = SweetNewObjectUtil.getSweetIntegralActivityPrizeVoArrayList();
            for (SweetIntegralActivityPrize prize : sweetIntegralActivityPrizes) {
                SweetIntegralActivityPrizeVo sweetIntegralActivityPrizeVo = SweetIntegralActivityPrizeVo.getNew().copy(prize);
                // 已发出
                Integer winPrizeNum = sweetIntegralActivityDrawMapper.selectCount(
                        Wrappers.lambdaQuery(SweetIntegralActivityDraw.class).eq(SweetIntegralActivityDraw::getPrizeId, prize.getPrizeId())
                );
                sweetIntegralActivityPrizeVo.setWinPrizeNum(winPrizeNum);
                prizeVoList.add(sweetIntegralActivityPrizeVo);
            }
            integralActivityVo.setPrizeList(prizeVoList);
        }
        return integralActivityVo;
    }

    @Override
    public Integer createForm(SweetIntegralActivityFromParam param) {
        try {
            SweetIntegralActivity sweetIntegralActivity = SweetIntegralActivityFromParam.getNew().copy(param);
            String integralActivityId = IDGenerator.nextSnowId();
            sweetIntegralActivity.setIntegralActivityId(integralActivityId);
            int insert = sweetIntegralActivityMapper.insert(sweetIntegralActivity);
            List<SweetIntegralActivityPrizeFormParam> prizeList = param.getPrizeList();
            if (!CollectionUtils.isEmpty(prizeList)) {
                for (SweetIntegralActivityPrizeFormParam prize : prizeList) {
                    SweetIntegralActivityPrize sweetIntegralActivityPrize = SweetIntegralActivityPrizeFormParam.getNew().copy(prize);
                    sweetIntegralActivityPrize.setPrizeId(IDGenerator.nextSnowId());
                    sweetIntegralActivityPrize.setIntegralActivityId(integralActivityId);
                    sweetIntegralActivityPrizeMapper.insert(sweetIntegralActivityPrize);
                }
            }
            // TODO: 2021/10/20 增加redis处理
            return insert;
        } catch (Exception e) {
            log.error("创建活动失败 [e:{}]", e);
            return 0;
        }
    }

    @Override
    public Integer updateForm(SweetIntegralActivityFromParam param) {
        try {
            SweetIntegralActivity sweetIntegralActivity = SweetIntegralActivityFromParam.getNew().copy(param);
            sweetIntegralActivity.setUpdatedAt(LocalDateTime.now());
            String integralActivityId = param.getIntegralActivityId();
            int update = sweetIntegralActivityMapper.update(
                    sweetIntegralActivity,
                    Wrappers.lambdaUpdate(SweetIntegralActivity.class).eq(SweetIntegralActivity::getIntegralActivityId, integralActivityId)
            );
            List<SweetIntegralActivityPrizeFormParam> prizeList = param.getPrizeList();
            if (!CollectionUtils.isEmpty(prizeList)) {
                for (SweetIntegralActivityPrizeFormParam prize : prizeList) {
                    SweetIntegralActivityPrize sweetIntegralActivityPrize = SweetIntegralActivityPrizeFormParam.getNew().copy(prize);
                    sweetIntegralActivityPrize.setUpdatedAt(LocalDateTime.now());
                    sweetIntegralActivityPrize.setIntegralActivityId(integralActivityId);
                    sweetIntegralActivityPrizeMapper.update(
                            sweetIntegralActivityPrize,
                            Wrappers.lambdaUpdate(SweetIntegralActivityPrize.class).eq(SweetIntegralActivityPrize::getPrizeId, prize.getPrizeId())
                    );
                }
            }
            // TODO: 2021/10/20 增加redis处理
            return update;
        } catch (Exception e) {
            log.error("编辑活动失败 [e:{}]", e);
            return 0;
        }
    }
}
