package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.commons.lang.util.DESUtils;
import com.liquidnet.commons.lang.util.SensitizeUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamUserIdentityVo", description = "用户身份信息")
@Data
public class AdamUserIdentityInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5828611827493373384L;
    @ApiModelProperty(position = 10, value = "用户ID[30]")
    private String uid;
    @ApiModelProperty(position = 11, value = "脱敏姓名[30]")
    private String name;
    @ApiModelProperty(position = 12, value = "脱敏手机号[11]")
    private String mobile;
    @ApiModelProperty(position = 15, value = "数据包")
    private String packet;

    private static final AdamUserIdentityInfoVo obj = new AdamUserIdentityInfoVo();

    public static AdamUserIdentityInfoVo getNew() {
        return obj.clone();
    }

    @Override
    public AdamUserIdentityInfoVo clone() {
        try {
            return (AdamUserIdentityInfoVo) super.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamUserIdentityInfoVo();
        }
    }

    /**
     * 脱敏处理
     *
     * @return AdamUserIdentityVo
     */
    public AdamUserIdentityInfoVo desensitize() {
        try {
            this.packet = DESUtils.DES().encrypt(uid.concat(",").concat(name).concat(",").concat(mobile));
        } catch (Exception e) {
            this.packet = "Nil";
        }
        this.setName(SensitizeUtil.custom(this.getName(), 0, 1));
        this.setMobile(SensitizeUtil.custom(this.getMobile(), 3, 4));
        return this;
    }
}
